package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ExperimentEntityName
import scala.jdk.CollectionConverters.*
final case class DeleteTrialComponentRequest(
    trialComponentName: ExperimentEntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentRequest = {
    import DeleteTrialComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentRequest
      .builder()
      .trialComponentName(
        ExperimentEntityName.unwrap(trialComponentName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteTrialComponentRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteTrialComponentRequest.wrap(buildAwsValue())
}
object DeleteTrialComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteTrialComponentRequest =
      zio.aws.sagemaker.model.DeleteTrialComponentRequest(trialComponentName)
    def trialComponentName: ExperimentEntityName
    def getTrialComponentName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(trialComponentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentRequest
  ) extends zio.aws.sagemaker.model.DeleteTrialComponentRequest.ReadOnly {
    override val trialComponentName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives
        .ExperimentEntityName(impl.trialComponentName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentRequest
  ): zio.aws.sagemaker.model.DeleteTrialComponentRequest.ReadOnly = new Wrapper(
    impl
  )
}
