package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.WorkteamName
import scala.jdk.CollectionConverters.*
final case class DeleteWorkteamRequest(workteamName: WorkteamName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamRequest = {
    import DeleteWorkteamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamRequest
      .builder()
      .workteamName(WorkteamName.unwrap(workteamName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteWorkteamRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteWorkteamRequest.wrap(buildAwsValue())
}
object DeleteWorkteamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteWorkteamRequest =
      zio.aws.sagemaker.model.DeleteWorkteamRequest(workteamName)
    def workteamName: WorkteamName
    def getWorkteamName: ZIO[Any, Nothing, WorkteamName] =
      ZIO.succeed(workteamName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamRequest
  ) extends zio.aws.sagemaker.model.DeleteWorkteamRequest.ReadOnly {
    override val workteamName: WorkteamName =
      zio.aws.sagemaker.model.primitives.WorkteamName(impl.workteamName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamRequest
  ): zio.aws.sagemaker.model.DeleteWorkteamRequest.ReadOnly = new Wrapper(impl)
}
