package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  AppArn,
  Timestamp,
  FailureReason,
  DomainId,
  AppName,
  UserProfileName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeAppResponse(
    appArn: Optional[AppArn] = Optional.Absent,
    appType: Optional[zio.aws.sagemaker.model.AppType] = Optional.Absent,
    appName: Optional[AppName] = Optional.Absent,
    domainId: Optional[DomainId] = Optional.Absent,
    userProfileName: Optional[UserProfileName] = Optional.Absent,
    status: Optional[zio.aws.sagemaker.model.AppStatus] = Optional.Absent,
    lastHealthCheckTimestamp: Optional[Timestamp] = Optional.Absent,
    lastUserActivityTimestamp: Optional[Timestamp] = Optional.Absent,
    creationTime: Optional[CreationTime] = Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent,
    resourceSpec: Optional[zio.aws.sagemaker.model.ResourceSpec] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeAppResponse = {
    import DescribeAppResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeAppResponse
      .builder()
      .optionallyWith(
        appArn.map(value => AppArn.unwrap(value): java.lang.String)
      )(_.appArn)
      .optionallyWith(appType.map(value => value.unwrap))(_.appType)
      .optionallyWith(
        appName.map(value => AppName.unwrap(value): java.lang.String)
      )(_.appName)
      .optionallyWith(
        domainId.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.domainId)
      .optionallyWith(
        userProfileName.map(value =>
          UserProfileName.unwrap(value): java.lang.String
        )
      )(_.userProfileName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastHealthCheckTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastHealthCheckTimestamp)
      .optionallyWith(
        lastUserActivityTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUserActivityTimestamp)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(resourceSpec.map(value => value.buildAwsValue()))(
        _.resourceSpec
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeAppResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeAppResponse.wrap(buildAwsValue())
}
object DescribeAppResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeAppResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeAppResponse =
      zio.aws.sagemaker.model.DescribeAppResponse(
        appArn.map(value => value),
        appType.map(value => value),
        appName.map(value => value),
        domainId.map(value => value),
        userProfileName.map(value => value),
        status.map(value => value),
        lastHealthCheckTimestamp.map(value => value),
        lastUserActivityTimestamp.map(value => value),
        creationTime.map(value => value),
        failureReason.map(value => value),
        resourceSpec.map(value => value.asEditable)
      )
    def appArn: Optional[AppArn]
    def appType: Optional[zio.aws.sagemaker.model.AppType]
    def appName: Optional[AppName]
    def domainId: Optional[DomainId]
    def userProfileName: Optional[UserProfileName]
    def status: Optional[zio.aws.sagemaker.model.AppStatus]
    def lastHealthCheckTimestamp: Optional[Timestamp]
    def lastUserActivityTimestamp: Optional[Timestamp]
    def creationTime: Optional[CreationTime]
    def failureReason: Optional[FailureReason]
    def resourceSpec: Optional[zio.aws.sagemaker.model.ResourceSpec.ReadOnly]
    def getAppArn: ZIO[Any, AwsError, AppArn] =
      AwsError.unwrapOptionField("appArn", appArn)
    def getAppType: ZIO[Any, AwsError, zio.aws.sagemaker.model.AppType] =
      AwsError.unwrapOptionField("appType", appType)
    def getAppName: ZIO[Any, AwsError, AppName] =
      AwsError.unwrapOptionField("appName", appName)
    def getDomainId: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("domainId", domainId)
    def getUserProfileName: ZIO[Any, AwsError, UserProfileName] =
      AwsError.unwrapOptionField("userProfileName", userProfileName)
    def getStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.AppStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLastHealthCheckTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastHealthCheckTimestamp", lastHealthCheckTimestamp)
    def getLastUserActivityTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastUserActivityTimestamp", lastUserActivityTimestamp)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getResourceSpec
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      AwsError.unwrapOptionField("resourceSpec", resourceSpec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAppResponse
  ) extends zio.aws.sagemaker.model.DescribeAppResponse.ReadOnly {
    override val appArn: Optional[AppArn] = zio.aws.core.internal
      .optionalFromNullable(impl.appArn())
      .map(value => zio.aws.sagemaker.model.primitives.AppArn(value))
    override val appType: Optional[zio.aws.sagemaker.model.AppType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appType())
        .map(value => zio.aws.sagemaker.model.AppType.wrap(value))
    override val appName: Optional[AppName] = zio.aws.core.internal
      .optionalFromNullable(impl.appName())
      .map(value => zio.aws.sagemaker.model.primitives.AppName(value))
    override val domainId: Optional[DomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainId())
      .map(value => zio.aws.sagemaker.model.primitives.DomainId(value))
    override val userProfileName: Optional[UserProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userProfileName())
        .map(value => zio.aws.sagemaker.model.primitives.UserProfileName(value))
    override val status: Optional[zio.aws.sagemaker.model.AppStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.AppStatus.wrap(value))
    override val lastHealthCheckTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastHealthCheckTimestamp())
        .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastUserActivityTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUserActivityTimestamp())
        .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val resourceSpec
        : Optional[zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceSpec())
        .map(value => zio.aws.sagemaker.model.ResourceSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAppResponse
  ): zio.aws.sagemaker.model.DescribeAppResponse.ReadOnly = new Wrapper(impl)
}
