package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ExperimentEntityNameOrArn
import scala.jdk.CollectionConverters.*
final case class DescribeContextRequest(
    contextName: ExperimentEntityNameOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeContextRequest = {
    import DescribeContextRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeContextRequest
      .builder()
      .contextName(
        ExperimentEntityNameOrArn.unwrap(contextName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeContextRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeContextRequest.wrap(buildAwsValue())
}
object DescribeContextRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeContextRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeContextRequest =
      zio.aws.sagemaker.model.DescribeContextRequest(contextName)
    def contextName: ExperimentEntityNameOrArn
    def getContextName: ZIO[Any, Nothing, ExperimentEntityNameOrArn] =
      ZIO.succeed(contextName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeContextRequest
  ) extends zio.aws.sagemaker.model.DescribeContextRequest.ReadOnly {
    override val contextName: ExperimentEntityNameOrArn =
      zio.aws.sagemaker.model.primitives
        .ExperimentEntityNameOrArn(impl.contextName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeContextRequest
  ): zio.aws.sagemaker.model.DescribeContextRequest.ReadOnly = new Wrapper(impl)
}
