package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  ExperimentDescription,
  ExperimentEntityName,
  Timestamp,
  ContextArn,
  LineageGroupArn,
  String256,
  StringParameterValue
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeContextResponse(
    contextName: Optional[ExperimentEntityName] = Optional.Absent,
    contextArn: Optional[ContextArn] = Optional.Absent,
    source: Optional[zio.aws.sagemaker.model.ContextSource] = Optional.Absent,
    contextType: Optional[String256] = Optional.Absent,
    description: Optional[ExperimentDescription] = Optional.Absent,
    properties: Optional[Map[StringParameterValue, StringParameterValue]] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[zio.aws.sagemaker.model.UserContext] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext] =
      Optional.Absent,
    lineageGroupArn: Optional[LineageGroupArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeContextResponse = {
    import DescribeContextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeContextResponse
      .builder()
      .optionallyWith(
        contextName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.contextName)
      .optionallyWith(
        contextArn.map(value => ContextArn.unwrap(value): java.lang.String)
      )(_.contextArn)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        contextType.map(value => String256.unwrap(value): java.lang.String)
      )(_.contextType)
      .optionallyWith(
        description.map(value =>
          ExperimentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (StringParameterValue.unwrap(
                key
              ): java.lang.String) -> (StringParameterValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.properties)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .optionallyWith(
        lineageGroupArn.map(value =>
          LineageGroupArn.unwrap(value): java.lang.String
        )
      )(_.lineageGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeContextResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeContextResponse.wrap(buildAwsValue())
}
object DescribeContextResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeContextResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeContextResponse =
      zio.aws.sagemaker.model.DescribeContextResponse(
        contextName.map(value => value),
        contextArn.map(value => value),
        source.map(value => value.asEditable),
        contextType.map(value => value),
        description.map(value => value),
        properties.map(value => value),
        creationTime.map(value => value),
        createdBy.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable),
        lineageGroupArn.map(value => value)
      )
    def contextName: Optional[ExperimentEntityName]
    def contextArn: Optional[ContextArn]
    def source: Optional[zio.aws.sagemaker.model.ContextSource.ReadOnly]
    def contextType: Optional[String256]
    def description: Optional[ExperimentDescription]
    def properties: Optional[Map[StringParameterValue, StringParameterValue]]
    def creationTime: Optional[Timestamp]
    def createdBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def lastModifiedTime: Optional[Timestamp]
    def lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def lineageGroupArn: Optional[LineageGroupArn]
    def getContextName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("contextName", contextName)
    def getContextArn: ZIO[Any, AwsError, ContextArn] =
      AwsError.unwrapOptionField("contextArn", contextArn)
    def getSource
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ContextSource.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getContextType: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("contextType", contextType)
    def getDescription: ZIO[Any, AwsError, ExperimentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getProperties
        : ZIO[Any, AwsError, Map[StringParameterValue, StringParameterValue]] =
      AwsError.unwrapOptionField("properties", properties)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLineageGroupArn: ZIO[Any, AwsError, LineageGroupArn] =
      AwsError.unwrapOptionField("lineageGroupArn", lineageGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeContextResponse
  ) extends zio.aws.sagemaker.model.DescribeContextResponse.ReadOnly {
    override val contextName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contextName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val contextArn: Optional[ContextArn] = zio.aws.core.internal
      .optionalFromNullable(impl.contextArn())
      .map(value => zio.aws.sagemaker.model.primitives.ContextArn(value))
    override val source
        : Optional[zio.aws.sagemaker.model.ContextSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.sagemaker.model.ContextSource.wrap(value))
    override val contextType: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.contextType())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val description: Optional[ExperimentDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentDescription(value)
        )
    override val properties
        : Optional[Map[StringParameterValue, StringParameterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.properties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives
                .StringParameterValue(key) -> zio.aws.sagemaker.model.primitives
                .StringParameterValue(value)
            })
            .toMap
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val lineageGroupArn: Optional[LineageGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lineageGroupArn())
        .map(value => zio.aws.sagemaker.model.primitives.LineageGroupArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeContextResponse
  ): zio.aws.sagemaker.model.DescribeContextResponse.ReadOnly = new Wrapper(
    impl
  )
}
