package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{EntityName, NextToken}
import scala.jdk.CollectionConverters.*
final case class DescribeDeviceRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    deviceName: EntityName,
    deviceFleetName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeDeviceRequest = {
    import DescribeDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeDeviceRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .deviceName(EntityName.unwrap(deviceName): java.lang.String)
      .deviceFleetName(EntityName.unwrap(deviceFleetName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeDeviceRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeDeviceRequest.wrap(buildAwsValue())
}
object DescribeDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeDeviceRequest =
      zio.aws.sagemaker.model.DescribeDeviceRequest(
        nextToken.map(value => value),
        deviceName,
        deviceFleetName
      )
    def nextToken: Optional[NextToken]
    def deviceName: EntityName
    def deviceFleetName: EntityName
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDeviceName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(deviceName)
    def getDeviceFleetName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(deviceFleetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDeviceRequest
  ) extends zio.aws.sagemaker.model.DescribeDeviceRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val deviceName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceName())
    override val deviceFleetName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceFleetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeDeviceRequest
  ): zio.aws.sagemaker.model.DescribeDeviceRequest.ReadOnly = new Wrapper(impl)
}
