package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  EdgeDeploymentPlanArn,
  Timestamp,
  Integer,
  EntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeEdgeDeploymentPlanResponse(
    edgeDeploymentPlanArn: EdgeDeploymentPlanArn,
    edgeDeploymentPlanName: EntityName,
    modelConfigs: Iterable[zio.aws.sagemaker.model.EdgeDeploymentModelConfig],
    deviceFleetName: EntityName,
    edgeDeploymentSuccess: Optional[Integer] = Optional.Absent,
    edgeDeploymentPending: Optional[Integer] = Optional.Absent,
    edgeDeploymentFailed: Optional[Integer] = Optional.Absent,
    stages: Iterable[zio.aws.sagemaker.model.DeploymentStageStatusSummary],
    nextToken: Optional[NextToken] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanResponse = {
    import DescribeEdgeDeploymentPlanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanResponse
      .builder()
      .edgeDeploymentPlanArn(
        EdgeDeploymentPlanArn.unwrap(edgeDeploymentPlanArn): java.lang.String
      )
      .edgeDeploymentPlanName(
        EntityName.unwrap(edgeDeploymentPlanName): java.lang.String
      )
      .modelConfigs(modelConfigs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .deviceFleetName(EntityName.unwrap(deviceFleetName): java.lang.String)
      .optionallyWith(
        edgeDeploymentSuccess.map(value => value: java.lang.Integer)
      )(_.edgeDeploymentSuccess)
      .optionallyWith(
        edgeDeploymentPending.map(value => value: java.lang.Integer)
      )(_.edgeDeploymentPending)
      .optionallyWith(
        edgeDeploymentFailed.map(value => value: java.lang.Integer)
      )(_.edgeDeploymentFailed)
      .stages(stages.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeEdgeDeploymentPlanResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeEdgeDeploymentPlanResponse
      .wrap(buildAwsValue())
}
object DescribeEdgeDeploymentPlanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeEdgeDeploymentPlanResponse =
      zio.aws.sagemaker.model.DescribeEdgeDeploymentPlanResponse(
        edgeDeploymentPlanArn,
        edgeDeploymentPlanName,
        modelConfigs.map { item =>
          item.asEditable
        },
        deviceFleetName,
        edgeDeploymentSuccess.map(value => value),
        edgeDeploymentPending.map(value => value),
        edgeDeploymentFailed.map(value => value),
        stages.map { item =>
          item.asEditable
        },
        nextToken.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def edgeDeploymentPlanArn: EdgeDeploymentPlanArn
    def edgeDeploymentPlanName: EntityName
    def modelConfigs
        : List[zio.aws.sagemaker.model.EdgeDeploymentModelConfig.ReadOnly]
    def deviceFleetName: EntityName
    def edgeDeploymentSuccess: Optional[Integer]
    def edgeDeploymentPending: Optional[Integer]
    def edgeDeploymentFailed: Optional[Integer]
    def stages
        : List[zio.aws.sagemaker.model.DeploymentStageStatusSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def getEdgeDeploymentPlanArn: ZIO[Any, Nothing, EdgeDeploymentPlanArn] =
      ZIO.succeed(edgeDeploymentPlanArn)
    def getEdgeDeploymentPlanName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(edgeDeploymentPlanName)
    def getModelConfigs: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.EdgeDeploymentModelConfig.ReadOnly
    ]] = ZIO.succeed(modelConfigs)
    def getDeviceFleetName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(deviceFleetName)
    def getEdgeDeploymentSuccess: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("edgeDeploymentSuccess", edgeDeploymentSuccess)
    def getEdgeDeploymentPending: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("edgeDeploymentPending", edgeDeploymentPending)
    def getEdgeDeploymentFailed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("edgeDeploymentFailed", edgeDeploymentFailed)
    def getStages: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.DeploymentStageStatusSummary.ReadOnly
    ]] = ZIO.succeed(stages)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanResponse
  ) extends zio.aws.sagemaker.model.DescribeEdgeDeploymentPlanResponse.ReadOnly {
    override val edgeDeploymentPlanArn: EdgeDeploymentPlanArn =
      zio.aws.sagemaker.model.primitives
        .EdgeDeploymentPlanArn(impl.edgeDeploymentPlanArn())
    override val edgeDeploymentPlanName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.edgeDeploymentPlanName())
    override val modelConfigs
        : List[zio.aws.sagemaker.model.EdgeDeploymentModelConfig.ReadOnly] =
      impl
        .modelConfigs()
        .asScala
        .map { item =>
          zio.aws.sagemaker.model.EdgeDeploymentModelConfig.wrap(item)
        }
        .toList
    override val deviceFleetName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceFleetName())
    override val edgeDeploymentSuccess: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edgeDeploymentSuccess())
        .map(value => value: Integer)
    override val edgeDeploymentPending: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edgeDeploymentPending())
        .map(value => value: Integer)
    override val edgeDeploymentFailed: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.edgeDeploymentFailed())
      .map(value => value: Integer)
    override val stages
        : List[zio.aws.sagemaker.model.DeploymentStageStatusSummary.ReadOnly] =
      impl
        .stages()
        .asScala
        .map { item =>
          zio.aws.sagemaker.model.DeploymentStageStatusSummary.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanResponse
  ): zio.aws.sagemaker.model.DescribeEdgeDeploymentPlanResponse.ReadOnly =
    new Wrapper(impl)
}
