package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  EdgeVersion,
  EdgePackagingJobArn,
  S3Uri,
  Timestamp,
  KmsKeyId,
  EntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeEdgePackagingJobResponse(
    edgePackagingJobArn: EdgePackagingJobArn,
    edgePackagingJobName: EntityName,
    compilationJobName: Optional[EntityName] = Optional.Absent,
    modelName: Optional[EntityName] = Optional.Absent,
    modelVersion: Optional[EdgeVersion] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    outputConfig: Optional[zio.aws.sagemaker.model.EdgeOutputConfig] =
      Optional.Absent,
    resourceKey: Optional[KmsKeyId] = Optional.Absent,
    edgePackagingJobStatus: zio.aws.sagemaker.model.EdgePackagingJobStatus,
    edgePackagingJobStatusMessage: Optional[String] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    modelArtifact: Optional[S3Uri] = Optional.Absent,
    modelSignature: Optional[String] = Optional.Absent,
    presetDeploymentOutput: Optional[
      zio.aws.sagemaker.model.EdgePresetDeploymentOutput
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobResponse = {
    import DescribeEdgePackagingJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobResponse
      .builder()
      .edgePackagingJobArn(
        EdgePackagingJobArn.unwrap(edgePackagingJobArn): java.lang.String
      )
      .edgePackagingJobName(
        EntityName.unwrap(edgePackagingJobName): java.lang.String
      )
      .optionallyWith(
        compilationJobName.map(value =>
          EntityName.unwrap(value): java.lang.String
        )
      )(_.compilationJobName)
      .optionallyWith(
        modelName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        modelVersion.map(value => EdgeVersion.unwrap(value): java.lang.String)
      )(_.modelVersion)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(outputConfig.map(value => value.buildAwsValue()))(
        _.outputConfig
      )
      .optionallyWith(
        resourceKey.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.resourceKey)
      .edgePackagingJobStatus(edgePackagingJobStatus.unwrap)
      .optionallyWith(
        edgePackagingJobStatusMessage.map(value => value: java.lang.String)
      )(_.edgePackagingJobStatusMessage)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        modelArtifact.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.modelArtifact)
      .optionallyWith(modelSignature.map(value => value: java.lang.String))(
        _.modelSignature
      )
      .optionallyWith(
        presetDeploymentOutput.map(value => value.buildAwsValue())
      )(_.presetDeploymentOutput)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeEdgePackagingJobResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeEdgePackagingJobResponse
      .wrap(buildAwsValue())
}
object DescribeEdgePackagingJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeEdgePackagingJobResponse =
      zio.aws.sagemaker.model.DescribeEdgePackagingJobResponse(
        edgePackagingJobArn,
        edgePackagingJobName,
        compilationJobName.map(value => value),
        modelName.map(value => value),
        modelVersion.map(value => value),
        roleArn.map(value => value),
        outputConfig.map(value => value.asEditable),
        resourceKey.map(value => value),
        edgePackagingJobStatus,
        edgePackagingJobStatusMessage.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        modelArtifact.map(value => value),
        modelSignature.map(value => value),
        presetDeploymentOutput.map(value => value.asEditable)
      )
    def edgePackagingJobArn: EdgePackagingJobArn
    def edgePackagingJobName: EntityName
    def compilationJobName: Optional[EntityName]
    def modelName: Optional[EntityName]
    def modelVersion: Optional[EdgeVersion]
    def roleArn: Optional[RoleArn]
    def outputConfig
        : Optional[zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly]
    def resourceKey: Optional[KmsKeyId]
    def edgePackagingJobStatus: zio.aws.sagemaker.model.EdgePackagingJobStatus
    def edgePackagingJobStatusMessage: Optional[String]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def modelArtifact: Optional[S3Uri]
    def modelSignature: Optional[String]
    def presetDeploymentOutput
        : Optional[zio.aws.sagemaker.model.EdgePresetDeploymentOutput.ReadOnly]
    def getEdgePackagingJobArn: ZIO[Any, Nothing, EdgePackagingJobArn] =
      ZIO.succeed(edgePackagingJobArn)
    def getEdgePackagingJobName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(edgePackagingJobName)
    def getCompilationJobName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("compilationJobName", compilationJobName)
    def getModelName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getModelVersion: ZIO[Any, AwsError, EdgeVersion] =
      AwsError.unwrapOptionField("modelVersion", modelVersion)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outputConfig", outputConfig)
    def getResourceKey: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("resourceKey", resourceKey)
    def getEdgePackagingJobStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.EdgePackagingJobStatus] =
      ZIO.succeed(edgePackagingJobStatus)
    def getEdgePackagingJobStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "edgePackagingJobStatusMessage",
        edgePackagingJobStatusMessage
      )
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getModelArtifact: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("modelArtifact", modelArtifact)
    def getModelSignature: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("modelSignature", modelSignature)
    def getPresetDeploymentOutput: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.EdgePresetDeploymentOutput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "presetDeploymentOutput",
      presetDeploymentOutput
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobResponse
  ) extends zio.aws.sagemaker.model.DescribeEdgePackagingJobResponse.ReadOnly {
    override val edgePackagingJobArn: EdgePackagingJobArn =
      zio.aws.sagemaker.model.primitives
        .EdgePackagingJobArn(impl.edgePackagingJobArn())
    override val edgePackagingJobName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.edgePackagingJobName())
    override val compilationJobName: Optional[EntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compilationJobName())
        .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val modelName: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val modelVersion: Optional[EdgeVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.modelVersion())
      .map(value => zio.aws.sagemaker.model.primitives.EdgeVersion(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val outputConfig
        : Optional[zio.aws.sagemaker.model.EdgeOutputConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputConfig())
        .map(value => zio.aws.sagemaker.model.EdgeOutputConfig.wrap(value))
    override val resourceKey: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceKey())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val edgePackagingJobStatus
        : zio.aws.sagemaker.model.EdgePackagingJobStatus =
      zio.aws.sagemaker.model.EdgePackagingJobStatus
        .wrap(impl.edgePackagingJobStatus())
    override val edgePackagingJobStatusMessage: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edgePackagingJobStatusMessage())
        .map(value => value: String)
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val modelArtifact: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArtifact())
      .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val modelSignature: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.modelSignature())
      .map(value => value: String)
    override val presetDeploymentOutput: Optional[
      zio.aws.sagemaker.model.EdgePresetDeploymentOutput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.presetDeploymentOutput())
      .map(value =>
        zio.aws.sagemaker.model.EdgePresetDeploymentOutput.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobResponse
  ): zio.aws.sagemaker.model.DescribeEdgePackagingJobResponse.ReadOnly =
    new Wrapper(impl)
}
