package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ExperimentEntityName
import scala.jdk.CollectionConverters.*
final case class DescribeExperimentRequest(
    experimentName: ExperimentEntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeExperimentRequest = {
    import DescribeExperimentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeExperimentRequest
      .builder()
      .experimentName(
        ExperimentEntityName.unwrap(experimentName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeExperimentRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeExperimentRequest.wrap(buildAwsValue())
}
object DescribeExperimentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeExperimentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeExperimentRequest =
      zio.aws.sagemaker.model.DescribeExperimentRequest(experimentName)
    def experimentName: ExperimentEntityName
    def getExperimentName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(experimentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeExperimentRequest
  ) extends zio.aws.sagemaker.model.DescribeExperimentRequest.ReadOnly {
    override val experimentName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives
        .ExperimentEntityName(impl.experimentName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeExperimentRequest
  ): zio.aws.sagemaker.model.DescribeExperimentRequest.ReadOnly = new Wrapper(
    impl
  )
}
