package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.MonitoringJobDefinitionName
import scala.jdk.CollectionConverters.*
final case class DescribeModelExplainabilityJobDefinitionRequest(
    jobDefinitionName: MonitoringJobDefinitionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionRequest = {
    import DescribeModelExplainabilityJobDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionRequest
      .builder()
      .jobDefinitionName(
        MonitoringJobDefinitionName.unwrap(jobDefinitionName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeModelExplainabilityJobDefinitionRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeModelExplainabilityJobDefinitionRequest
      .wrap(buildAwsValue())
}
object DescribeModelExplainabilityJobDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribeModelExplainabilityJobDefinitionRequest =
      zio.aws.sagemaker.model
        .DescribeModelExplainabilityJobDefinitionRequest(jobDefinitionName)
    def jobDefinitionName: MonitoringJobDefinitionName
    def getJobDefinitionName: ZIO[Any, Nothing, MonitoringJobDefinitionName] =
      ZIO.succeed(jobDefinitionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionRequest
  ) extends zio.aws.sagemaker.model.DescribeModelExplainabilityJobDefinitionRequest.ReadOnly {
    override val jobDefinitionName: MonitoringJobDefinitionName =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionName(impl.jobDefinitionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionRequest
  ): zio.aws.sagemaker.model.DescribeModelExplainabilityJobDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
