package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.NotebookInstanceName
import scala.jdk.CollectionConverters.*
final case class DescribeNotebookInstanceRequest(
    notebookInstanceName: NotebookInstanceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceRequest = {
    import DescribeNotebookInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceRequest
      .builder()
      .notebookInstanceName(
        NotebookInstanceName.unwrap(notebookInstanceName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeNotebookInstanceRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeNotebookInstanceRequest
      .wrap(buildAwsValue())
}
object DescribeNotebookInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeNotebookInstanceRequest =
      zio.aws.sagemaker.model
        .DescribeNotebookInstanceRequest(notebookInstanceName)
    def notebookInstanceName: NotebookInstanceName
    def getNotebookInstanceName: ZIO[Any, Nothing, NotebookInstanceName] =
      ZIO.succeed(notebookInstanceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceRequest
  ) extends zio.aws.sagemaker.model.DescribeNotebookInstanceRequest.ReadOnly {
    override val notebookInstanceName: NotebookInstanceName =
      zio.aws.sagemaker.model.primitives
        .NotebookInstanceName(impl.notebookInstanceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceRequest
  ): zio.aws.sagemaker.model.DescribeNotebookInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
