package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.PipelineExecutionArn
import scala.jdk.CollectionConverters.*
final case class DescribePipelineExecutionRequest(
    pipelineExecutionArn: PipelineExecutionArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribePipelineExecutionRequest = {
    import DescribePipelineExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribePipelineExecutionRequest
      .builder()
      .pipelineExecutionArn(
        PipelineExecutionArn.unwrap(pipelineExecutionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribePipelineExecutionRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribePipelineExecutionRequest
      .wrap(buildAwsValue())
}
object DescribePipelineExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribePipelineExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribePipelineExecutionRequest =
      zio.aws.sagemaker.model
        .DescribePipelineExecutionRequest(pipelineExecutionArn)
    def pipelineExecutionArn: PipelineExecutionArn
    def getPipelineExecutionArn: ZIO[Any, Nothing, PipelineExecutionArn] =
      ZIO.succeed(pipelineExecutionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribePipelineExecutionRequest
  ) extends zio.aws.sagemaker.model.DescribePipelineExecutionRequest.ReadOnly {
    override val pipelineExecutionArn: PipelineExecutionArn =
      zio.aws.sagemaker.model.primitives
        .PipelineExecutionArn(impl.pipelineExecutionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribePipelineExecutionRequest
  ): zio.aws.sagemaker.model.DescribePipelineExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
