package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.PipelineName
import scala.jdk.CollectionConverters.*
final case class DescribePipelineRequest(pipelineName: PipelineName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribePipelineRequest = {
    import DescribePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribePipelineRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribePipelineRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribePipelineRequest.wrap(buildAwsValue())
}
object DescribePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribePipelineRequest =
      zio.aws.sagemaker.model.DescribePipelineRequest(pipelineName)
    def pipelineName: PipelineName
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribePipelineRequest
  ) extends zio.aws.sagemaker.model.DescribePipelineRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.sagemaker.model.primitives.PipelineName(impl.pipelineName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribePipelineRequest
  ): zio.aws.sagemaker.model.DescribePipelineRequest.ReadOnly = new Wrapper(
    impl
  )
}
