package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.WorkforceName
import scala.jdk.CollectionConverters.*
final case class DescribeWorkforceRequest(workforceName: WorkforceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceRequest = {
    import DescribeWorkforceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceRequest
      .builder()
      .workforceName(WorkforceName.unwrap(workforceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeWorkforceRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeWorkforceRequest.wrap(buildAwsValue())
}
object DescribeWorkforceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeWorkforceRequest =
      zio.aws.sagemaker.model.DescribeWorkforceRequest(workforceName)
    def workforceName: WorkforceName
    def getWorkforceName: ZIO[Any, Nothing, WorkforceName] =
      ZIO.succeed(workforceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceRequest
  ) extends zio.aws.sagemaker.model.DescribeWorkforceRequest.ReadOnly {
    override val workforceName: WorkforceName =
      zio.aws.sagemaker.model.primitives.WorkforceName(impl.workforceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceRequest
  ): zio.aws.sagemaker.model.DescribeWorkforceRequest.ReadOnly = new Wrapper(
    impl
  )
}
