package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{DeviceName, Percentage}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DeviceSelectionConfig(
    deviceSubsetType: zio.aws.sagemaker.model.DeviceSubsetType,
    percentage: Optional[Percentage] = Optional.Absent,
    deviceNames: Optional[Iterable[DeviceName]] = Optional.Absent,
    deviceNameContains: Optional[DeviceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeviceSelectionConfig = {
    import DeviceSelectionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeviceSelectionConfig
      .builder()
      .deviceSubsetType(deviceSubsetType.unwrap)
      .optionallyWith(
        percentage.map(value => Percentage.unwrap(value): Integer)
      )(_.percentage)
      .optionallyWith(
        deviceNames.map(value =>
          value.map { item =>
            DeviceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.deviceNames)
      .optionallyWith(
        deviceNameContains.map(value =>
          DeviceName.unwrap(value): java.lang.String
        )
      )(_.deviceNameContains)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeviceSelectionConfig.ReadOnly =
    zio.aws.sagemaker.model.DeviceSelectionConfig.wrap(buildAwsValue())
}
object DeviceSelectionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeviceSelectionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeviceSelectionConfig =
      zio.aws.sagemaker.model.DeviceSelectionConfig(
        deviceSubsetType,
        percentage.map(value => value),
        deviceNames.map(value => value),
        deviceNameContains.map(value => value)
      )
    def deviceSubsetType: zio.aws.sagemaker.model.DeviceSubsetType
    def percentage: Optional[Percentage]
    def deviceNames: Optional[List[DeviceName]]
    def deviceNameContains: Optional[DeviceName]
    def getDeviceSubsetType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.DeviceSubsetType] =
      ZIO.succeed(deviceSubsetType)
    def getPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("percentage", percentage)
    def getDeviceNames: ZIO[Any, AwsError, List[DeviceName]] =
      AwsError.unwrapOptionField("deviceNames", deviceNames)
    def getDeviceNameContains: ZIO[Any, AwsError, DeviceName] =
      AwsError.unwrapOptionField("deviceNameContains", deviceNameContains)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeviceSelectionConfig
  ) extends zio.aws.sagemaker.model.DeviceSelectionConfig.ReadOnly {
    override val deviceSubsetType: zio.aws.sagemaker.model.DeviceSubsetType =
      zio.aws.sagemaker.model.DeviceSubsetType.wrap(impl.deviceSubsetType())
    override val percentage: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.percentage())
      .map(value => zio.aws.sagemaker.model.primitives.Percentage(value))
    override val deviceNames: Optional[List[DeviceName]] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.DeviceName(item)
        }.toList
      )
    override val deviceNameContains: Optional[DeviceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceNameContains())
        .map(value => zio.aws.sagemaker.model.primitives.DeviceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeviceSelectionConfig
  ): zio.aws.sagemaker.model.DeviceSelectionConfig.ReadOnly = new Wrapper(impl)
}
