package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait EdgePresetDeploymentType {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentType
}
object EdgePresetDeploymentType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentType
  ): zio.aws.sagemaker.model.EdgePresetDeploymentType = value match {
    case software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentType.GREENGRASS_V2_COMPONENT =>
      val r = GreengrassV2Component
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.EdgePresetDeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentType =
      software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentType.UNKNOWN_TO_SDK_VERSION
  }
  case object GreengrassV2Component
      extends zio.aws.sagemaker.model.EdgePresetDeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentType =
      software.amazon.awssdk.services.sagemaker.model.EdgePresetDeploymentType.GREENGRASS_V2_COMPONENT
  }
}
