package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.InferenceSpecificationName
import scala.jdk.CollectionConverters.*
final case class EndpointInputConfiguration(
    instanceType: zio.aws.sagemaker.model.ProductionVariantInstanceType,
    inferenceSpecificationName: Optional[InferenceSpecificationName] =
      Optional.Absent,
    environmentParameterRanges: Optional[
      zio.aws.sagemaker.model.EnvironmentParameterRanges
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EndpointInputConfiguration = {
    import EndpointInputConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EndpointInputConfiguration
      .builder()
      .instanceType(instanceType.unwrap)
      .optionallyWith(
        inferenceSpecificationName.map(value =>
          InferenceSpecificationName.unwrap(value): java.lang.String
        )
      )(_.inferenceSpecificationName)
      .optionallyWith(
        environmentParameterRanges.map(value => value.buildAwsValue())
      )(_.environmentParameterRanges)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EndpointInputConfiguration.ReadOnly =
    zio.aws.sagemaker.model.EndpointInputConfiguration.wrap(buildAwsValue())
}
object EndpointInputConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EndpointInputConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EndpointInputConfiguration =
      zio.aws.sagemaker.model.EndpointInputConfiguration(
        instanceType,
        inferenceSpecificationName.map(value => value),
        environmentParameterRanges.map(value => value.asEditable)
      )
    def instanceType: zio.aws.sagemaker.model.ProductionVariantInstanceType
    def inferenceSpecificationName: Optional[InferenceSpecificationName]
    def environmentParameterRanges
        : Optional[zio.aws.sagemaker.model.EnvironmentParameterRanges.ReadOnly]
    def getInstanceType: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ProductionVariantInstanceType
    ] = ZIO.succeed(instanceType)
    def getInferenceSpecificationName
        : ZIO[Any, AwsError, InferenceSpecificationName] =
      AwsError.unwrapOptionField(
        "inferenceSpecificationName",
        inferenceSpecificationName
      )
    def getEnvironmentParameterRanges: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.EnvironmentParameterRanges.ReadOnly
    ] = AwsError.unwrapOptionField(
      "environmentParameterRanges",
      environmentParameterRanges
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointInputConfiguration
  ) extends zio.aws.sagemaker.model.EndpointInputConfiguration.ReadOnly {
    override val instanceType
        : zio.aws.sagemaker.model.ProductionVariantInstanceType =
      zio.aws.sagemaker.model.ProductionVariantInstanceType
        .wrap(impl.instanceType())
    override val inferenceSpecificationName
        : Optional[InferenceSpecificationName] = zio.aws.core.internal
      .optionalFromNullable(impl.inferenceSpecificationName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.InferenceSpecificationName(value)
      )
    override val environmentParameterRanges: Optional[
      zio.aws.sagemaker.model.EnvironmentParameterRanges.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentParameterRanges())
      .map(value =>
        zio.aws.sagemaker.model.EnvironmentParameterRanges.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointInputConfiguration
  ): zio.aws.sagemaker.model.EndpointInputConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
