package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class EndpointOutputConfiguration(
    endpointName: String,
    variantName: String,
    instanceType: zio.aws.sagemaker.model.ProductionVariantInstanceType,
    initialInstanceCount: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EndpointOutputConfiguration = {
    import EndpointOutputConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EndpointOutputConfiguration
      .builder()
      .endpointName(endpointName: java.lang.String)
      .variantName(variantName: java.lang.String)
      .instanceType(instanceType.unwrap)
      .initialInstanceCount(initialInstanceCount: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EndpointOutputConfiguration.ReadOnly =
    zio.aws.sagemaker.model.EndpointOutputConfiguration.wrap(buildAwsValue())
}
object EndpointOutputConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EndpointOutputConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EndpointOutputConfiguration =
      zio.aws.sagemaker.model.EndpointOutputConfiguration(
        endpointName,
        variantName,
        instanceType,
        initialInstanceCount
      )
    def endpointName: String
    def variantName: String
    def instanceType: zio.aws.sagemaker.model.ProductionVariantInstanceType
    def initialInstanceCount: Integer
    def getEndpointName: ZIO[Any, Nothing, String] = ZIO.succeed(endpointName)
    def getVariantName: ZIO[Any, Nothing, String] = ZIO.succeed(variantName)
    def getInstanceType: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ProductionVariantInstanceType
    ] = ZIO.succeed(instanceType)
    def getInitialInstanceCount: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(initialInstanceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointOutputConfiguration
  ) extends zio.aws.sagemaker.model.EndpointOutputConfiguration.ReadOnly {
    override val endpointName: String = impl.endpointName(): String
    override val variantName: String = impl.variantName(): String
    override val instanceType
        : zio.aws.sagemaker.model.ProductionVariantInstanceType =
      zio.aws.sagemaker.model.ProductionVariantInstanceType
        .wrap(impl.instanceType())
    override val initialInstanceCount: Integer =
      impl.initialInstanceCount(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointOutputConfiguration
  ): zio.aws.sagemaker.model.EndpointOutputConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
