package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EnvironmentParameterRanges(
    categoricalParameterRanges: Optional[
      Iterable[zio.aws.sagemaker.model.CategoricalParameter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EnvironmentParameterRanges = {
    import EnvironmentParameterRanges.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EnvironmentParameterRanges
      .builder()
      .optionallyWith(
        categoricalParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.categoricalParameterRanges)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EnvironmentParameterRanges.ReadOnly =
    zio.aws.sagemaker.model.EnvironmentParameterRanges.wrap(buildAwsValue())
}
object EnvironmentParameterRanges {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EnvironmentParameterRanges
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EnvironmentParameterRanges =
      zio.aws.sagemaker.model.EnvironmentParameterRanges(
        categoricalParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def categoricalParameterRanges
        : Optional[List[zio.aws.sagemaker.model.CategoricalParameter.ReadOnly]]
    def getCategoricalParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.CategoricalParameter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "categoricalParameterRanges",
      categoricalParameterRanges
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EnvironmentParameterRanges
  ) extends zio.aws.sagemaker.model.EnvironmentParameterRanges.ReadOnly {
    override val categoricalParameterRanges: Optional[
      List[zio.aws.sagemaker.model.CategoricalParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.categoricalParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.CategoricalParameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EnvironmentParameterRanges
  ): zio.aws.sagemaker.model.EnvironmentParameterRanges.ReadOnly = new Wrapper(
    impl
  )
}
