package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ExecutionStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ExecutionStatus
}
object ExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ExecutionStatus
  ): zio.aws.sagemaker.model.ExecutionStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.ExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ExecutionStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.sagemaker.model.ExecutionStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.ExecutionStatus.COMPLETED_WITH_VIOLATIONS =>
      val r = CompletedWithViolations
      r
    case software.amazon.awssdk.services.sagemaker.model.ExecutionStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.ExecutionStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.ExecutionStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.sagemaker.model.ExecutionStatus.STOPPED =>
      val r = Stopped
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ExecutionStatus =
      software.amazon.awssdk.services.sagemaker.model.ExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.sagemaker.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ExecutionStatus =
      software.amazon.awssdk.services.sagemaker.model.ExecutionStatus.PENDING
  }
  case object Completed extends zio.aws.sagemaker.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ExecutionStatus =
      software.amazon.awssdk.services.sagemaker.model.ExecutionStatus.COMPLETED
  }
  case object CompletedWithViolations
      extends zio.aws.sagemaker.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ExecutionStatus =
      software.amazon.awssdk.services.sagemaker.model.ExecutionStatus.COMPLETED_WITH_VIOLATIONS
  }
  case object InProgress extends zio.aws.sagemaker.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ExecutionStatus =
      software.amazon.awssdk.services.sagemaker.model.ExecutionStatus.IN_PROGRESS
  }
  case object Failed extends zio.aws.sagemaker.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ExecutionStatus =
      software.amazon.awssdk.services.sagemaker.model.ExecutionStatus.FAILED
  }
  case object Stopping extends zio.aws.sagemaker.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ExecutionStatus =
      software.amazon.awssdk.services.sagemaker.model.ExecutionStatus.STOPPING
  }
  case object Stopped extends zio.aws.sagemaker.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ExecutionStatus =
      software.amazon.awssdk.services.sagemaker.model.ExecutionStatus.STOPPED
  }
}
