package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait FailureHandlingPolicy {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.FailureHandlingPolicy
}
object FailureHandlingPolicy {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.FailureHandlingPolicy
  ): zio.aws.sagemaker.model.FailureHandlingPolicy = value match {
    case software.amazon.awssdk.services.sagemaker.model.FailureHandlingPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.FailureHandlingPolicy.ROLLBACK_ON_FAILURE =>
      val r = ROLLBACK_ON_FAILURE
      r
    case software.amazon.awssdk.services.sagemaker.model.FailureHandlingPolicy.DO_NOTHING =>
      val r = DO_NOTHING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.FailureHandlingPolicy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FailureHandlingPolicy =
      software.amazon.awssdk.services.sagemaker.model.FailureHandlingPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object ROLLBACK_ON_FAILURE
      extends zio.aws.sagemaker.model.FailureHandlingPolicy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FailureHandlingPolicy =
      software.amazon.awssdk.services.sagemaker.model.FailureHandlingPolicy.ROLLBACK_ON_FAILURE
  }
  case object DO_NOTHING extends zio.aws.sagemaker.model.FailureHandlingPolicy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FailureHandlingPolicy =
      software.amazon.awssdk.services.sagemaker.model.FailureHandlingPolicy.DO_NOTHING
  }
}
