package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait FeatureGroupSortOrder {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.FeatureGroupSortOrder
}
object FeatureGroupSortOrder {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.FeatureGroupSortOrder
  ): zio.aws.sagemaker.model.FeatureGroupSortOrder = value match {
    case software.amazon.awssdk.services.sagemaker.model.FeatureGroupSortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.FeatureGroupSortOrder.ASCENDING =>
      val r = Ascending
      r
    case software.amazon.awssdk.services.sagemaker.model.FeatureGroupSortOrder.DESCENDING =>
      val r = Descending
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.FeatureGroupSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FeatureGroupSortOrder =
      software.amazon.awssdk.services.sagemaker.model.FeatureGroupSortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object Ascending extends zio.aws.sagemaker.model.FeatureGroupSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FeatureGroupSortOrder =
      software.amazon.awssdk.services.sagemaker.model.FeatureGroupSortOrder.ASCENDING
  }
  case object Descending extends zio.aws.sagemaker.model.FeatureGroupSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FeatureGroupSortOrder =
      software.amazon.awssdk.services.sagemaker.model.FeatureGroupSortOrder.DESCENDING
  }
}
