package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait FileSystemAccessMode {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.FileSystemAccessMode
}
object FileSystemAccessMode {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.FileSystemAccessMode
  ): zio.aws.sagemaker.model.FileSystemAccessMode = value match {
    case software.amazon.awssdk.services.sagemaker.model.FileSystemAccessMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.FileSystemAccessMode.RW =>
      val r = rw
      r
    case software.amazon.awssdk.services.sagemaker.model.FileSystemAccessMode.RO =>
      val r = ro
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.FileSystemAccessMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FileSystemAccessMode =
      software.amazon.awssdk.services.sagemaker.model.FileSystemAccessMode.UNKNOWN_TO_SDK_VERSION
  }
  case object rw extends zio.aws.sagemaker.model.FileSystemAccessMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FileSystemAccessMode =
      software.amazon.awssdk.services.sagemaker.model.FileSystemAccessMode.RW
  }
  case object ro extends zio.aws.sagemaker.model.FileSystemAccessMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FileSystemAccessMode =
      software.amazon.awssdk.services.sagemaker.model.FileSystemAccessMode.RO
  }
}
