package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait FlowDefinitionStatus {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.FlowDefinitionStatus
}
object FlowDefinitionStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.FlowDefinitionStatus
  ): zio.aws.sagemaker.model.FlowDefinitionStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.FlowDefinitionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.FlowDefinitionStatus.INITIALIZING =>
      val r = Initializing
      r
    case software.amazon.awssdk.services.sagemaker.model.FlowDefinitionStatus.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.sagemaker.model.FlowDefinitionStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.FlowDefinitionStatus.DELETING =>
      val r = Deleting
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.FlowDefinitionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FlowDefinitionStatus =
      software.amazon.awssdk.services.sagemaker.model.FlowDefinitionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Initializing
      extends zio.aws.sagemaker.model.FlowDefinitionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FlowDefinitionStatus =
      software.amazon.awssdk.services.sagemaker.model.FlowDefinitionStatus.INITIALIZING
  }
  case object Active extends zio.aws.sagemaker.model.FlowDefinitionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FlowDefinitionStatus =
      software.amazon.awssdk.services.sagemaker.model.FlowDefinitionStatus.ACTIVE
  }
  case object Failed extends zio.aws.sagemaker.model.FlowDefinitionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FlowDefinitionStatus =
      software.amazon.awssdk.services.sagemaker.model.FlowDefinitionStatus.FAILED
  }
  case object Deleting extends zio.aws.sagemaker.model.FlowDefinitionStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FlowDefinitionStatus =
      software.amazon.awssdk.services.sagemaker.model.FlowDefinitionStatus.DELETING
  }
}
