package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.HumanLoopActivationConditions
import scala.jdk.CollectionConverters.*
final case class HumanLoopActivationConditionsConfig(
    humanLoopActivationConditions: HumanLoopActivationConditions
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HumanLoopActivationConditionsConfig = {
    import HumanLoopActivationConditionsConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HumanLoopActivationConditionsConfig
      .builder()
      .humanLoopActivationConditions(
        HumanLoopActivationConditions.unwrap(
          humanLoopActivationConditions
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.HumanLoopActivationConditionsConfig.ReadOnly =
    zio.aws.sagemaker.model.HumanLoopActivationConditionsConfig
      .wrap(buildAwsValue())
}
object HumanLoopActivationConditionsConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HumanLoopActivationConditionsConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.HumanLoopActivationConditionsConfig =
      zio.aws.sagemaker.model
        .HumanLoopActivationConditionsConfig(humanLoopActivationConditions)
    def humanLoopActivationConditions: HumanLoopActivationConditions
    def getHumanLoopActivationConditions
        : ZIO[Any, Nothing, HumanLoopActivationConditions] =
      ZIO.succeed(humanLoopActivationConditions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HumanLoopActivationConditionsConfig
  ) extends zio.aws.sagemaker.model.HumanLoopActivationConditionsConfig.ReadOnly {
    override val humanLoopActivationConditions: HumanLoopActivationConditions =
      zio.aws.sagemaker.model.primitives
        .HumanLoopActivationConditions(impl.humanLoopActivationConditions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HumanLoopActivationConditionsConfig
  ): zio.aws.sagemaker.model.HumanLoopActivationConditionsConfig.ReadOnly =
    new Wrapper(impl)
}
