package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  TrainingJobName,
  Timestamp,
  FailureReason,
  HyperParameterTuningJobName,
  TrainingJobArn,
  HyperParameterKey,
  HyperParameterTrainingJobDefinitionName,
  HyperParameterValue
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class HyperParameterTrainingJobSummary(
    trainingJobDefinitionName: Optional[
      HyperParameterTrainingJobDefinitionName
    ] = Optional.Absent,
    trainingJobName: TrainingJobName,
    trainingJobArn: TrainingJobArn,
    tuningJobName: Optional[HyperParameterTuningJobName] = Optional.Absent,
    creationTime: Timestamp,
    trainingStartTime: Optional[Timestamp] = Optional.Absent,
    trainingEndTime: Optional[Timestamp] = Optional.Absent,
    trainingJobStatus: zio.aws.sagemaker.model.TrainingJobStatus,
    tunedHyperParameters: Map[HyperParameterKey, HyperParameterValue],
    failureReason: Optional[FailureReason] = Optional.Absent,
    finalHyperParameterTuningJobObjectiveMetric: Optional[
      zio.aws.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric
    ] = Optional.Absent,
    objectiveStatus: Optional[zio.aws.sagemaker.model.ObjectiveStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobSummary = {
    import HyperParameterTrainingJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobSummary
      .builder()
      .optionallyWith(
        trainingJobDefinitionName.map(value =>
          HyperParameterTrainingJobDefinitionName.unwrap(
            value
          ): java.lang.String
        )
      )(_.trainingJobDefinitionName)
      .trainingJobName(
        TrainingJobName.unwrap(trainingJobName): java.lang.String
      )
      .trainingJobArn(TrainingJobArn.unwrap(trainingJobArn): java.lang.String)
      .optionallyWith(
        tuningJobName.map(value =>
          HyperParameterTuningJobName.unwrap(value): java.lang.String
        )
      )(_.tuningJobName)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        trainingStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingStartTime)
      .optionallyWith(
        trainingEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingEndTime)
      .trainingJobStatus(trainingJobStatus.unwrap)
      .tunedHyperParameters(
        tunedHyperParameters
          .map({ case (key, value) =>
            (HyperParameterKey.unwrap(
              key
            ): java.lang.String) -> (HyperParameterValue.unwrap(
              value
            ): java.lang.String)
          })
          .asJava
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        finalHyperParameterTuningJobObjectiveMetric.map(value =>
          value.buildAwsValue()
        )
      )(_.finalHyperParameterTuningJobObjectiveMetric)
      .optionallyWith(objectiveStatus.map(value => value.unwrap))(
        _.objectiveStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly =
    zio.aws.sagemaker.model.HyperParameterTrainingJobSummary
      .wrap(buildAwsValue())
}
object HyperParameterTrainingJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.HyperParameterTrainingJobSummary =
      zio.aws.sagemaker.model.HyperParameterTrainingJobSummary(
        trainingJobDefinitionName.map(value => value),
        trainingJobName,
        trainingJobArn,
        tuningJobName.map(value => value),
        creationTime,
        trainingStartTime.map(value => value),
        trainingEndTime.map(value => value),
        trainingJobStatus,
        tunedHyperParameters,
        failureReason.map(value => value),
        finalHyperParameterTuningJobObjectiveMetric.map(value =>
          value.asEditable
        ),
        objectiveStatus.map(value => value)
      )
    def trainingJobDefinitionName
        : Optional[HyperParameterTrainingJobDefinitionName]
    def trainingJobName: TrainingJobName
    def trainingJobArn: TrainingJobArn
    def tuningJobName: Optional[HyperParameterTuningJobName]
    def creationTime: Timestamp
    def trainingStartTime: Optional[Timestamp]
    def trainingEndTime: Optional[Timestamp]
    def trainingJobStatus: zio.aws.sagemaker.model.TrainingJobStatus
    def tunedHyperParameters: Map[HyperParameterKey, HyperParameterValue]
    def failureReason: Optional[FailureReason]
    def finalHyperParameterTuningJobObjectiveMetric: Optional[
      zio.aws.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric.ReadOnly
    ]
    def objectiveStatus: Optional[zio.aws.sagemaker.model.ObjectiveStatus]
    def getTrainingJobDefinitionName
        : ZIO[Any, AwsError, HyperParameterTrainingJobDefinitionName] = AwsError
      .unwrapOptionField("trainingJobDefinitionName", trainingJobDefinitionName)
    def getTrainingJobName: ZIO[Any, Nothing, TrainingJobName] =
      ZIO.succeed(trainingJobName)
    def getTrainingJobArn: ZIO[Any, Nothing, TrainingJobArn] =
      ZIO.succeed(trainingJobArn)
    def getTuningJobName: ZIO[Any, AwsError, HyperParameterTuningJobName] =
      AwsError.unwrapOptionField("tuningJobName", tuningJobName)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getTrainingStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingStartTime", trainingStartTime)
    def getTrainingEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingEndTime", trainingEndTime)
    def getTrainingJobStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TrainingJobStatus] =
      ZIO.succeed(trainingJobStatus)
    def getTunedHyperParameters
        : ZIO[Any, Nothing, Map[HyperParameterKey, HyperParameterValue]] =
      ZIO.succeed(tunedHyperParameters)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getFinalHyperParameterTuningJobObjectiveMetric: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric.ReadOnly
    ] = AwsError.unwrapOptionField(
      "finalHyperParameterTuningJobObjectiveMetric",
      finalHyperParameterTuningJobObjectiveMetric
    )
    def getObjectiveStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ObjectiveStatus] =
      AwsError.unwrapOptionField("objectiveStatus", objectiveStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobSummary
  ) extends zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly {
    override val trainingJobDefinitionName
        : Optional[HyperParameterTrainingJobDefinitionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingJobDefinitionName())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .HyperParameterTrainingJobDefinitionName(value)
        )
    override val trainingJobName: TrainingJobName =
      zio.aws.sagemaker.model.primitives.TrainingJobName(impl.trainingJobName())
    override val trainingJobArn: TrainingJobArn =
      zio.aws.sagemaker.model.primitives.TrainingJobArn(impl.trainingJobArn())
    override val tuningJobName: Optional[HyperParameterTuningJobName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tuningJobName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.HyperParameterTuningJobName(value)
        )
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val trainingStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingStartTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val trainingEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingEndTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val trainingJobStatus: zio.aws.sagemaker.model.TrainingJobStatus =
      zio.aws.sagemaker.model.TrainingJobStatus.wrap(impl.trainingJobStatus())
    override val tunedHyperParameters
        : Map[HyperParameterKey, HyperParameterValue] = impl
      .tunedHyperParameters()
      .asScala
      .map({ case (key, value) =>
        zio.aws.sagemaker.model.primitives.HyperParameterKey(
          key
        ) -> zio.aws.sagemaker.model.primitives.HyperParameterValue(value)
      })
      .toMap
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val finalHyperParameterTuningJobObjectiveMetric: Optional[
      zio.aws.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.finalHyperParameterTuningJobObjectiveMetric())
      .map(value =>
        zio.aws.sagemaker.model.FinalHyperParameterTuningJobObjectiveMetric
          .wrap(value)
      )
    override val objectiveStatus
        : Optional[zio.aws.sagemaker.model.ObjectiveStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectiveStatus())
        .map(value => zio.aws.sagemaker.model.ObjectiveStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobSummary
  ): zio.aws.sagemaker.model.HyperParameterTrainingJobSummary.ReadOnly =
    new Wrapper(impl)
}
