package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait HyperParameterTuningJobStrategyType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyType
}
object HyperParameterTuningJobStrategyType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyType
  ): zio.aws.sagemaker.model.HyperParameterTuningJobStrategyType = value match {
    case software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyType.BAYESIAN =>
      val r = Bayesian
      r
    case software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyType.RANDOM =>
      val r = Random
      r
    case software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyType.HYPERBAND =>
      val r = Hyperband
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.HyperParameterTuningJobStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyType =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyType.UNKNOWN_TO_SDK_VERSION
  }
  case object Bayesian
      extends zio.aws.sagemaker.model.HyperParameterTuningJobStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyType =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyType.BAYESIAN
  }
  case object Random
      extends zio.aws.sagemaker.model.HyperParameterTuningJobStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyType =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyType.RANDOM
  }
  case object Hyperband
      extends zio.aws.sagemaker.model.HyperParameterTuningJobStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyType =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStrategyType.HYPERBAND
  }
}
