package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait InferenceExecutionMode {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.InferenceExecutionMode
}
object InferenceExecutionMode {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.InferenceExecutionMode
  ): zio.aws.sagemaker.model.InferenceExecutionMode = value match {
    case software.amazon.awssdk.services.sagemaker.model.InferenceExecutionMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.InferenceExecutionMode.SERIAL =>
      val r = Serial
      r
    case software.amazon.awssdk.services.sagemaker.model.InferenceExecutionMode.DIRECT =>
      val r = Direct
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.InferenceExecutionMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InferenceExecutionMode =
      software.amazon.awssdk.services.sagemaker.model.InferenceExecutionMode.UNKNOWN_TO_SDK_VERSION
  }
  case object Serial extends zio.aws.sagemaker.model.InferenceExecutionMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InferenceExecutionMode =
      software.amazon.awssdk.services.sagemaker.model.InferenceExecutionMode.SERIAL
  }
  case object Direct extends zio.aws.sagemaker.model.InferenceExecutionMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.InferenceExecutionMode =
      software.amazon.awssdk.services.sagemaker.model.InferenceExecutionMode.DIRECT
  }
}
