package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  FrameworkVersion,
  DataInputConfig,
  S3Uri
}
import scala.jdk.CollectionConverters.*
final case class InputConfig(
    s3Uri: S3Uri,
    dataInputConfig: DataInputConfig,
    framework: zio.aws.sagemaker.model.Framework,
    frameworkVersion: Optional[FrameworkVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.InputConfig = {
    import InputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.InputConfig
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .dataInputConfig(
        DataInputConfig.unwrap(dataInputConfig): java.lang.String
      )
      .framework(framework.unwrap)
      .optionallyWith(
        frameworkVersion.map(value =>
          FrameworkVersion.unwrap(value): java.lang.String
        )
      )(_.frameworkVersion)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.InputConfig.ReadOnly =
    zio.aws.sagemaker.model.InputConfig.wrap(buildAwsValue())
}
object InputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.InputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.InputConfig =
      zio.aws.sagemaker.model.InputConfig(
        s3Uri,
        dataInputConfig,
        framework,
        frameworkVersion.map(value => value)
      )
    def s3Uri: S3Uri
    def dataInputConfig: DataInputConfig
    def framework: zio.aws.sagemaker.model.Framework
    def frameworkVersion: Optional[FrameworkVersion]
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getDataInputConfig: ZIO[Any, Nothing, DataInputConfig] =
      ZIO.succeed(dataInputConfig)
    def getFramework: ZIO[Any, Nothing, zio.aws.sagemaker.model.Framework] =
      ZIO.succeed(framework)
    def getFrameworkVersion: ZIO[Any, AwsError, FrameworkVersion] =
      AwsError.unwrapOptionField("frameworkVersion", frameworkVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.InputConfig
  ) extends zio.aws.sagemaker.model.InputConfig.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3Uri())
    override val dataInputConfig: DataInputConfig =
      zio.aws.sagemaker.model.primitives.DataInputConfig(impl.dataInputConfig())
    override val framework: zio.aws.sagemaker.model.Framework =
      zio.aws.sagemaker.model.Framework.wrap(impl.framework())
    override val frameworkVersion: Optional[FrameworkVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.frameworkVersion())
        .map(value =>
          zio.aws.sagemaker.model.primitives.FrameworkVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.InputConfig
  ): zio.aws.sagemaker.model.InputConfig.ReadOnly = new Wrapper(impl)
}
