package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.StudioLifecycleConfigArn
import scala.jdk.CollectionConverters.*
final case class KernelGatewayAppSettings(
    defaultResourceSpec: Optional[zio.aws.sagemaker.model.ResourceSpec] =
      Optional.Absent,
    customImages: Optional[Iterable[zio.aws.sagemaker.model.CustomImage]] =
      Optional.Absent,
    lifecycleConfigArns: Optional[Iterable[StudioLifecycleConfigArn]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.KernelGatewayAppSettings = {
    import KernelGatewayAppSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.KernelGatewayAppSettings
      .builder()
      .optionallyWith(defaultResourceSpec.map(value => value.buildAwsValue()))(
        _.defaultResourceSpec
      )
      .optionallyWith(
        customImages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customImages)
      .optionallyWith(
        lifecycleConfigArns.map(value =>
          value.map { item =>
            StudioLifecycleConfigArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.lifecycleConfigArns)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.KernelGatewayAppSettings.ReadOnly =
    zio.aws.sagemaker.model.KernelGatewayAppSettings.wrap(buildAwsValue())
}
object KernelGatewayAppSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.KernelGatewayAppSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.KernelGatewayAppSettings =
      zio.aws.sagemaker.model.KernelGatewayAppSettings(
        defaultResourceSpec.map(value => value.asEditable),
        customImages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lifecycleConfigArns.map(value => value)
      )
    def defaultResourceSpec
        : Optional[zio.aws.sagemaker.model.ResourceSpec.ReadOnly]
    def customImages
        : Optional[List[zio.aws.sagemaker.model.CustomImage.ReadOnly]]
    def lifecycleConfigArns: Optional[List[StudioLifecycleConfigArn]]
    def getDefaultResourceSpec
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      AwsError.unwrapOptionField("defaultResourceSpec", defaultResourceSpec)
    def getCustomImages: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.CustomImage.ReadOnly
    ]] = AwsError.unwrapOptionField("customImages", customImages)
    def getLifecycleConfigArns
        : ZIO[Any, AwsError, List[StudioLifecycleConfigArn]] =
      AwsError.unwrapOptionField("lifecycleConfigArns", lifecycleConfigArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.KernelGatewayAppSettings
  ) extends zio.aws.sagemaker.model.KernelGatewayAppSettings.ReadOnly {
    override val defaultResourceSpec
        : Optional[zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultResourceSpec())
        .map(value => zio.aws.sagemaker.model.ResourceSpec.wrap(value))
    override val customImages
        : Optional[List[zio.aws.sagemaker.model.CustomImage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customImages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.CustomImage.wrap(item)
          }.toList
        )
    override val lifecycleConfigArns: Optional[List[StudioLifecycleConfigArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleConfigArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.StudioLifecycleConfigArn(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.KernelGatewayAppSettings
  ): zio.aws.sagemaker.model.KernelGatewayAppSettings.ReadOnly = new Wrapper(
    impl
  )
}
