package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListCandidatesForAutoMlJobResponse(
    candidates: Iterable[zio.aws.sagemaker.model.AutoMLCandidate],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobResponse = {
    import ListCandidatesForAutoMlJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobResponse
      .builder()
      .candidates(candidates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListCandidatesForAutoMlJobResponse.ReadOnly =
    zio.aws.sagemaker.model.ListCandidatesForAutoMlJobResponse
      .wrap(buildAwsValue())
}
object ListCandidatesForAutoMlJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListCandidatesForAutoMlJobResponse =
      zio.aws.sagemaker.model.ListCandidatesForAutoMlJobResponse(
        candidates.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def candidates: List[zio.aws.sagemaker.model.AutoMLCandidate.ReadOnly]
    def nextToken: Optional[NextToken]
    def getCandidates: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.AutoMLCandidate.ReadOnly
    ]] = ZIO.succeed(candidates)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobResponse
  ) extends zio.aws.sagemaker.model.ListCandidatesForAutoMlJobResponse.ReadOnly {
    override val candidates
        : List[zio.aws.sagemaker.model.AutoMLCandidate.ReadOnly] = impl
      .candidates()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.AutoMLCandidate.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobResponse
  ): zio.aws.sagemaker.model.ListCandidatesForAutoMlJobResponse.ReadOnly =
    new Wrapper(impl)
}
