package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListFlowDefinitionsResponse(
    flowDefinitionSummaries: Iterable[
      zio.aws.sagemaker.model.FlowDefinitionSummary
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsResponse = {
    import ListFlowDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsResponse
      .builder()
      .flowDefinitionSummaries(flowDefinitionSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListFlowDefinitionsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListFlowDefinitionsResponse.wrap(buildAwsValue())
}
object ListFlowDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListFlowDefinitionsResponse =
      zio.aws.sagemaker.model.ListFlowDefinitionsResponse(
        flowDefinitionSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def flowDefinitionSummaries
        : List[zio.aws.sagemaker.model.FlowDefinitionSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getFlowDefinitionSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.FlowDefinitionSummary.ReadOnly
    ]] = ZIO.succeed(flowDefinitionSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsResponse
  ) extends zio.aws.sagemaker.model.ListFlowDefinitionsResponse.ReadOnly {
    override val flowDefinitionSummaries
        : List[zio.aws.sagemaker.model.FlowDefinitionSummary.ReadOnly] = impl
      .flowDefinitionSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.FlowDefinitionSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsResponse
  ): zio.aws.sagemaker.model.ListFlowDefinitionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
