package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListHumanTaskUisResponse(
    humanTaskUiSummaries: Iterable[zio.aws.sagemaker.model.HumanTaskUiSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisResponse = {
    import ListHumanTaskUisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisResponse
      .builder()
      .humanTaskUiSummaries(humanTaskUiSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListHumanTaskUisResponse.ReadOnly =
    zio.aws.sagemaker.model.ListHumanTaskUisResponse.wrap(buildAwsValue())
}
object ListHumanTaskUisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListHumanTaskUisResponse =
      zio.aws.sagemaker.model.ListHumanTaskUisResponse(
        humanTaskUiSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def humanTaskUiSummaries
        : List[zio.aws.sagemaker.model.HumanTaskUiSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getHumanTaskUiSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.HumanTaskUiSummary.ReadOnly
    ]] = ZIO.succeed(humanTaskUiSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisResponse
  ) extends zio.aws.sagemaker.model.ListHumanTaskUisResponse.ReadOnly {
    override val humanTaskUiSummaries
        : List[zio.aws.sagemaker.model.HumanTaskUiSummary.ReadOnly] = impl
      .humanTaskUiSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.HumanTaskUiSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisResponse
  ): zio.aws.sagemaker.model.ListHumanTaskUisResponse.ReadOnly = new Wrapper(
    impl
  )
}
