package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListImageVersionsResponse(
    imageVersions: Optional[Iterable[zio.aws.sagemaker.model.ImageVersion]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListImageVersionsResponse = {
    import ListImageVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListImageVersionsResponse
      .builder()
      .optionallyWith(
        imageVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.imageVersions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListImageVersionsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListImageVersionsResponse.wrap(buildAwsValue())
}
object ListImageVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListImageVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListImageVersionsResponse =
      zio.aws.sagemaker.model.ListImageVersionsResponse(
        imageVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def imageVersions
        : Optional[List[zio.aws.sagemaker.model.ImageVersion.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getImageVersions: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ImageVersion.ReadOnly
    ]] = AwsError.unwrapOptionField("imageVersions", imageVersions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListImageVersionsResponse
  ) extends zio.aws.sagemaker.model.ListImageVersionsResponse.ReadOnly {
    override val imageVersions
        : Optional[List[zio.aws.sagemaker.model.ImageVersion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.ImageVersion.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListImageVersionsResponse
  ): zio.aws.sagemaker.model.ListImageVersionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
