package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListLabelingJobsForWorkteamResponse(
    labelingJobSummaryList: Iterable[
      zio.aws.sagemaker.model.LabelingJobForWorkteamSummary
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamResponse = {
    import ListLabelingJobsForWorkteamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamResponse
      .builder()
      .labelingJobSummaryList(labelingJobSummaryList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListLabelingJobsForWorkteamResponse.ReadOnly =
    zio.aws.sagemaker.model.ListLabelingJobsForWorkteamResponse
      .wrap(buildAwsValue())
}
object ListLabelingJobsForWorkteamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ListLabelingJobsForWorkteamResponse =
      zio.aws.sagemaker.model.ListLabelingJobsForWorkteamResponse(
        labelingJobSummaryList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def labelingJobSummaryList
        : List[zio.aws.sagemaker.model.LabelingJobForWorkteamSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getLabelingJobSummaryList: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.LabelingJobForWorkteamSummary.ReadOnly
    ]] = ZIO.succeed(labelingJobSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamResponse
  ) extends zio.aws.sagemaker.model.ListLabelingJobsForWorkteamResponse.ReadOnly {
    override val labelingJobSummaryList
        : List[zio.aws.sagemaker.model.LabelingJobForWorkteamSummary.ReadOnly] =
      impl
        .labelingJobSummaryList()
        .asScala
        .map { item =>
          zio.aws.sagemaker.model.LabelingJobForWorkteamSummary.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamResponse
  ): zio.aws.sagemaker.model.ListLabelingJobsForWorkteamResponse.ReadOnly =
    new Wrapper(impl)
}
