package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  NextToken,
  NameContains,
  ArnOrName,
  MaxResults
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListModelPackagesRequest(
    creationTimeAfter: Optional[CreationTime] = Optional.Absent,
    creationTimeBefore: Optional[CreationTime] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nameContains: Optional[NameContains] = Optional.Absent,
    modelApprovalStatus: Optional[zio.aws.sagemaker.model.ModelApprovalStatus] =
      Optional.Absent,
    modelPackageGroupName: Optional[ArnOrName] = Optional.Absent,
    modelPackageType: Optional[zio.aws.sagemaker.model.ModelPackageType] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.ModelPackageSortBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest = {
    import ListModelPackagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest
      .builder()
      .optionallyWith(
        creationTimeAfter.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nameContains.map(value => NameContains.unwrap(value): java.lang.String)
      )(_.nameContains)
      .optionallyWith(modelApprovalStatus.map(value => value.unwrap))(
        _.modelApprovalStatus
      )
      .optionallyWith(
        modelPackageGroupName.map(value =>
          ArnOrName.unwrap(value): java.lang.String
        )
      )(_.modelPackageGroupName)
      .optionallyWith(modelPackageType.map(value => value.unwrap))(
        _.modelPackageType
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListModelPackagesRequest.ReadOnly =
    zio.aws.sagemaker.model.ListModelPackagesRequest.wrap(buildAwsValue())
}
object ListModelPackagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListModelPackagesRequest =
      zio.aws.sagemaker.model.ListModelPackagesRequest(
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        maxResults.map(value => value),
        nameContains.map(value => value),
        modelApprovalStatus.map(value => value),
        modelPackageGroupName.map(value => value),
        modelPackageType.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def creationTimeAfter: Optional[CreationTime]
    def creationTimeBefore: Optional[CreationTime]
    def maxResults: Optional[MaxResults]
    def nameContains: Optional[NameContains]
    def modelApprovalStatus
        : Optional[zio.aws.sagemaker.model.ModelApprovalStatus]
    def modelPackageGroupName: Optional[ArnOrName]
    def modelPackageType: Optional[zio.aws.sagemaker.model.ModelPackageType]
    def nextToken: Optional[NextToken]
    def sortBy: Optional[zio.aws.sagemaker.model.ModelPackageSortBy]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def getCreationTimeAfter: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNameContains: ZIO[Any, AwsError, NameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getModelApprovalStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelApprovalStatus] =
      AwsError.unwrapOptionField("modelApprovalStatus", modelApprovalStatus)
    def getModelPackageGroupName: ZIO[Any, AwsError, ArnOrName] =
      AwsError.unwrapOptionField("modelPackageGroupName", modelPackageGroupName)
    def getModelPackageType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelPackageType] =
      AwsError.unwrapOptionField("modelPackageType", modelPackageType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelPackageSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest
  ) extends zio.aws.sagemaker.model.ListModelPackagesRequest.ReadOnly {
    override val creationTimeAfter: Optional[CreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTimeAfter())
        .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val creationTimeBefore: Optional[CreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTimeBefore())
        .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nameContains: Optional[NameContains] = zio.aws.core.internal
      .optionalFromNullable(impl.nameContains())
      .map(value => zio.aws.sagemaker.model.primitives.NameContains(value))
    override val modelApprovalStatus
        : Optional[zio.aws.sagemaker.model.ModelApprovalStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelApprovalStatus())
        .map(value => zio.aws.sagemaker.model.ModelApprovalStatus.wrap(value))
    override val modelPackageGroupName: Optional[ArnOrName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelPackageGroupName())
        .map(value => zio.aws.sagemaker.model.primitives.ArnOrName(value))
    override val modelPackageType
        : Optional[zio.aws.sagemaker.model.ModelPackageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelPackageType())
        .map(value => zio.aws.sagemaker.model.ModelPackageType.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val sortBy: Optional[zio.aws.sagemaker.model.ModelPackageSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.ModelPackageSortBy.wrap(value))
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest
  ): zio.aws.sagemaker.model.ListModelPackagesRequest.ReadOnly = new Wrapper(
    impl
  )
}
