package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  EndpointName,
  Timestamp,
  NameContains,
  MaxResults
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListModelQualityJobDefinitionsRequest(
    endpointName: Optional[EndpointName] = Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.MonitoringJobDefinitionSortKey] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nameContains: Optional[NameContains] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    creationTimeAfter: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsRequest = {
    import ListModelQualityJobDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsRequest
      .builder()
      .optionallyWith(
        endpointName.map(value => EndpointName.unwrap(value): java.lang.String)
      )(_.endpointName)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nameContains.map(value => NameContains.unwrap(value): java.lang.String)
      )(_.nameContains)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListModelQualityJobDefinitionsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListModelQualityJobDefinitionsRequest
      .wrap(buildAwsValue())
}
object ListModelQualityJobDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ListModelQualityJobDefinitionsRequest =
      zio.aws.sagemaker.model.ListModelQualityJobDefinitionsRequest(
        endpointName.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        nameContains.map(value => value),
        creationTimeBefore.map(value => value),
        creationTimeAfter.map(value => value)
      )
    def endpointName: Optional[EndpointName]
    def sortBy: Optional[zio.aws.sagemaker.model.MonitoringJobDefinitionSortKey]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def nameContains: Optional[NameContains]
    def creationTimeBefore: Optional[Timestamp]
    def creationTimeAfter: Optional[Timestamp]
    def getEndpointName: ZIO[Any, AwsError, EndpointName] =
      AwsError.unwrapOptionField("endpointName", endpointName)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringJobDefinitionSortKey
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNameContains: ZIO[Any, AwsError, NameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsRequest
  ) extends zio.aws.sagemaker.model.ListModelQualityJobDefinitionsRequest.ReadOnly {
    override val endpointName: Optional[EndpointName] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointName())
      .map(value => zio.aws.sagemaker.model.primitives.EndpointName(value))
    override val sortBy
        : Optional[zio.aws.sagemaker.model.MonitoringJobDefinitionSortKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringJobDefinitionSortKey.wrap(value)
        )
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nameContains: Optional[NameContains] = zio.aws.core.internal
      .optionalFromNullable(impl.nameContains())
      .map(value => zio.aws.sagemaker.model.primitives.NameContains(value))
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsRequest
  ): zio.aws.sagemaker.model.ListModelQualityJobDefinitionsRequest.ReadOnly =
    new Wrapper(impl)
}
