package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListModelQualityJobDefinitionsResponse(
    jobDefinitionSummaries: Iterable[
      zio.aws.sagemaker.model.MonitoringJobDefinitionSummary
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsResponse = {
    import ListModelQualityJobDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsResponse
      .builder()
      .jobDefinitionSummaries(jobDefinitionSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListModelQualityJobDefinitionsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListModelQualityJobDefinitionsResponse
      .wrap(buildAwsValue())
}
object ListModelQualityJobDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ListModelQualityJobDefinitionsResponse =
      zio.aws.sagemaker.model.ListModelQualityJobDefinitionsResponse(
        jobDefinitionSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def jobDefinitionSummaries
        : List[zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getJobDefinitionSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
    ]] = ZIO.succeed(jobDefinitionSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsResponse
  ) extends zio.aws.sagemaker.model.ListModelQualityJobDefinitionsResponse.ReadOnly {
    override val jobDefinitionSummaries: List[
      zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.ReadOnly
    ] = impl
      .jobDefinitionSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.MonitoringJobDefinitionSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsResponse
  ): zio.aws.sagemaker.model.ListModelQualityJobDefinitionsResponse.ReadOnly =
    new Wrapper(impl)
}
