package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  EndpointName,
  MonitoringJobDefinitionName,
  MonitoringScheduleName,
  Timestamp,
  MaxResults
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListMonitoringExecutionsRequest(
    monitoringScheduleName: Optional[MonitoringScheduleName] = Optional.Absent,
    endpointName: Optional[EndpointName] = Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.MonitoringExecutionSortKey] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    scheduledTimeBefore: Optional[Timestamp] = Optional.Absent,
    scheduledTimeAfter: Optional[Timestamp] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    lastModifiedTimeBefore: Optional[Timestamp] = Optional.Absent,
    lastModifiedTimeAfter: Optional[Timestamp] = Optional.Absent,
    statusEquals: Optional[zio.aws.sagemaker.model.ExecutionStatus] =
      Optional.Absent,
    monitoringJobDefinitionName: Optional[MonitoringJobDefinitionName] =
      Optional.Absent,
    monitoringTypeEquals: Optional[zio.aws.sagemaker.model.MonitoringType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest = {
    import ListMonitoringExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest
      .builder()
      .optionallyWith(
        monitoringScheduleName.map(value =>
          MonitoringScheduleName.unwrap(value): java.lang.String
        )
      )(_.monitoringScheduleName)
      .optionallyWith(
        endpointName.map(value => EndpointName.unwrap(value): java.lang.String)
      )(_.endpointName)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        scheduledTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.scheduledTimeBefore)
      .optionallyWith(
        scheduledTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.scheduledTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        lastModifiedTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimeBefore)
      .optionallyWith(
        lastModifiedTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimeAfter)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(
        monitoringJobDefinitionName.map(value =>
          MonitoringJobDefinitionName.unwrap(value): java.lang.String
        )
      )(_.monitoringJobDefinitionName)
      .optionallyWith(monitoringTypeEquals.map(value => value.unwrap))(
        _.monitoringTypeEquals
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListMonitoringExecutionsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListMonitoringExecutionsRequest
      .wrap(buildAwsValue())
}
object ListMonitoringExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListMonitoringExecutionsRequest =
      zio.aws.sagemaker.model.ListMonitoringExecutionsRequest(
        monitoringScheduleName.map(value => value),
        endpointName.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        scheduledTimeBefore.map(value => value),
        scheduledTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        creationTimeAfter.map(value => value),
        lastModifiedTimeBefore.map(value => value),
        lastModifiedTimeAfter.map(value => value),
        statusEquals.map(value => value),
        monitoringJobDefinitionName.map(value => value),
        monitoringTypeEquals.map(value => value)
      )
    def monitoringScheduleName: Optional[MonitoringScheduleName]
    def endpointName: Optional[EndpointName]
    def sortBy: Optional[zio.aws.sagemaker.model.MonitoringExecutionSortKey]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def scheduledTimeBefore: Optional[Timestamp]
    def scheduledTimeAfter: Optional[Timestamp]
    def creationTimeBefore: Optional[Timestamp]
    def creationTimeAfter: Optional[Timestamp]
    def lastModifiedTimeBefore: Optional[Timestamp]
    def lastModifiedTimeAfter: Optional[Timestamp]
    def statusEquals: Optional[zio.aws.sagemaker.model.ExecutionStatus]
    def monitoringJobDefinitionName: Optional[MonitoringJobDefinitionName]
    def monitoringTypeEquals: Optional[zio.aws.sagemaker.model.MonitoringType]
    def getMonitoringScheduleName: ZIO[Any, AwsError, MonitoringScheduleName] =
      AwsError.unwrapOptionField(
        "monitoringScheduleName",
        monitoringScheduleName
      )
    def getEndpointName: ZIO[Any, AwsError, EndpointName] =
      AwsError.unwrapOptionField("endpointName", endpointName)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringExecutionSortKey
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getScheduledTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scheduledTimeBefore", scheduledTimeBefore)
    def getScheduledTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scheduledTimeAfter", scheduledTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getLastModifiedTimeBefore: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastModifiedTimeBefore", lastModifiedTimeBefore)
    def getLastModifiedTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTimeAfter", lastModifiedTimeAfter)
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ExecutionStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getMonitoringJobDefinitionName
        : ZIO[Any, AwsError, MonitoringJobDefinitionName] =
      AwsError.unwrapOptionField(
        "monitoringJobDefinitionName",
        monitoringJobDefinitionName
      )
    def getMonitoringTypeEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MonitoringType] =
      AwsError.unwrapOptionField("monitoringTypeEquals", monitoringTypeEquals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest
  ) extends zio.aws.sagemaker.model.ListMonitoringExecutionsRequest.ReadOnly {
    override val monitoringScheduleName: Optional[MonitoringScheduleName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringScheduleName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.MonitoringScheduleName(value)
        )
    override val endpointName: Optional[EndpointName] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointName())
      .map(value => zio.aws.sagemaker.model.primitives.EndpointName(value))
    override val sortBy
        : Optional[zio.aws.sagemaker.model.MonitoringExecutionSortKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringExecutionSortKey.wrap(value)
        )
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val scheduledTimeBefore: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledTimeBefore())
        .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val scheduledTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduledTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTimeBefore: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimeBefore())
        .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTimeAfter: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimeAfter())
        .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val statusEquals
        : Optional[zio.aws.sagemaker.model.ExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusEquals())
        .map(value => zio.aws.sagemaker.model.ExecutionStatus.wrap(value))
    override val monitoringJobDefinitionName
        : Optional[MonitoringJobDefinitionName] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringJobDefinitionName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MonitoringJobDefinitionName(value)
      )
    override val monitoringTypeEquals
        : Optional[zio.aws.sagemaker.model.MonitoringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringTypeEquals())
        .map(value => zio.aws.sagemaker.model.MonitoringType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest
  ): zio.aws.sagemaker.model.ListMonitoringExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
