package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModelBiasJobInput(
    endpointInput: Optional[zio.aws.sagemaker.model.EndpointInput] =
      Optional.Absent,
    batchTransformInput: Optional[zio.aws.sagemaker.model.BatchTransformInput] =
      Optional.Absent,
    groundTruthS3Input: zio.aws.sagemaker.model.MonitoringGroundTruthS3Input
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelBiasJobInput = {
    import ModelBiasJobInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelBiasJobInput
      .builder()
      .optionallyWith(endpointInput.map(value => value.buildAwsValue()))(
        _.endpointInput
      )
      .optionallyWith(batchTransformInput.map(value => value.buildAwsValue()))(
        _.batchTransformInput
      )
      .groundTruthS3Input(groundTruthS3Input.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelBiasJobInput.ReadOnly =
    zio.aws.sagemaker.model.ModelBiasJobInput.wrap(buildAwsValue())
}
object ModelBiasJobInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelBiasJobInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelBiasJobInput =
      zio.aws.sagemaker.model.ModelBiasJobInput(
        endpointInput.map(value => value.asEditable),
        batchTransformInput.map(value => value.asEditable),
        groundTruthS3Input.asEditable
      )
    def endpointInput: Optional[zio.aws.sagemaker.model.EndpointInput.ReadOnly]
    def batchTransformInput
        : Optional[zio.aws.sagemaker.model.BatchTransformInput.ReadOnly]
    def groundTruthS3Input
        : zio.aws.sagemaker.model.MonitoringGroundTruthS3Input.ReadOnly
    def getEndpointInput
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.EndpointInput.ReadOnly] =
      AwsError.unwrapOptionField("endpointInput", endpointInput)
    def getBatchTransformInput: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.BatchTransformInput.ReadOnly
    ] = AwsError.unwrapOptionField("batchTransformInput", batchTransformInput)
    def getGroundTruthS3Input: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringGroundTruthS3Input.ReadOnly
    ] = ZIO.succeed(groundTruthS3Input)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelBiasJobInput
  ) extends zio.aws.sagemaker.model.ModelBiasJobInput.ReadOnly {
    override val endpointInput
        : Optional[zio.aws.sagemaker.model.EndpointInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointInput())
        .map(value => zio.aws.sagemaker.model.EndpointInput.wrap(value))
    override val batchTransformInput
        : Optional[zio.aws.sagemaker.model.BatchTransformInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.batchTransformInput())
        .map(value => zio.aws.sagemaker.model.BatchTransformInput.wrap(value))
    override val groundTruthS3Input
        : zio.aws.sagemaker.model.MonitoringGroundTruthS3Input.ReadOnly =
      zio.aws.sagemaker.model.MonitoringGroundTruthS3Input
        .wrap(impl.groundTruthS3Input())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelBiasJobInput
  ): zio.aws.sagemaker.model.ModelBiasJobInput.ReadOnly = new Wrapper(impl)
}
