package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  InvocationsMaxRetries,
  InvocationsTimeoutInSeconds
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ModelClientConfig(
    invocationsTimeoutInSeconds: Optional[InvocationsTimeoutInSeconds] =
      Optional.Absent,
    invocationsMaxRetries: Optional[InvocationsMaxRetries] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelClientConfig = {
    import ModelClientConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelClientConfig
      .builder()
      .optionallyWith(
        invocationsTimeoutInSeconds.map(value =>
          InvocationsTimeoutInSeconds.unwrap(value): Integer
        )
      )(_.invocationsTimeoutInSeconds)
      .optionallyWith(
        invocationsMaxRetries.map(value =>
          InvocationsMaxRetries.unwrap(value): Integer
        )
      )(_.invocationsMaxRetries)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelClientConfig.ReadOnly =
    zio.aws.sagemaker.model.ModelClientConfig.wrap(buildAwsValue())
}
object ModelClientConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelClientConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelClientConfig =
      zio.aws.sagemaker.model.ModelClientConfig(
        invocationsTimeoutInSeconds.map(value => value),
        invocationsMaxRetries.map(value => value)
      )
    def invocationsTimeoutInSeconds: Optional[InvocationsTimeoutInSeconds]
    def invocationsMaxRetries: Optional[InvocationsMaxRetries]
    def getInvocationsTimeoutInSeconds
        : ZIO[Any, AwsError, InvocationsTimeoutInSeconds] =
      AwsError.unwrapOptionField(
        "invocationsTimeoutInSeconds",
        invocationsTimeoutInSeconds
      )
    def getInvocationsMaxRetries: ZIO[Any, AwsError, InvocationsMaxRetries] =
      AwsError.unwrapOptionField("invocationsMaxRetries", invocationsMaxRetries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelClientConfig
  ) extends zio.aws.sagemaker.model.ModelClientConfig.ReadOnly {
    override val invocationsTimeoutInSeconds
        : Optional[InvocationsTimeoutInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.invocationsTimeoutInSeconds())
      .map(value =>
        zio.aws.sagemaker.model.primitives.InvocationsTimeoutInSeconds(value)
      )
    override val invocationsMaxRetries: Optional[InvocationsMaxRetries] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invocationsMaxRetries())
        .map(value =>
          zio.aws.sagemaker.model.primitives.InvocationsMaxRetries(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelClientConfig
  ): zio.aws.sagemaker.model.ModelClientConfig.ReadOnly = new Wrapper(impl)
}
