package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  ModelPackageVersion,
  ModelPackageArn,
  EntityDescription,
  EntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ModelPackageSummary(
    modelPackageName: EntityName,
    modelPackageGroupName: Optional[EntityName] = Optional.Absent,
    modelPackageVersion: Optional[ModelPackageVersion] = Optional.Absent,
    modelPackageArn: ModelPackageArn,
    modelPackageDescription: Optional[EntityDescription] = Optional.Absent,
    creationTime: CreationTime,
    modelPackageStatus: zio.aws.sagemaker.model.ModelPackageStatus,
    modelApprovalStatus: Optional[zio.aws.sagemaker.model.ModelApprovalStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelPackageSummary = {
    import ModelPackageSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelPackageSummary
      .builder()
      .modelPackageName(EntityName.unwrap(modelPackageName): java.lang.String)
      .optionallyWith(
        modelPackageGroupName.map(value =>
          EntityName.unwrap(value): java.lang.String
        )
      )(_.modelPackageGroupName)
      .optionallyWith(
        modelPackageVersion.map(value =>
          ModelPackageVersion.unwrap(value): Integer
        )
      )(_.modelPackageVersion)
      .modelPackageArn(
        ModelPackageArn.unwrap(modelPackageArn): java.lang.String
      )
      .optionallyWith(
        modelPackageDescription.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.modelPackageDescription)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .modelPackageStatus(modelPackageStatus.unwrap)
      .optionallyWith(modelApprovalStatus.map(value => value.unwrap))(
        _.modelApprovalStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelPackageSummary.ReadOnly =
    zio.aws.sagemaker.model.ModelPackageSummary.wrap(buildAwsValue())
}
object ModelPackageSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelPackageSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelPackageSummary =
      zio.aws.sagemaker.model.ModelPackageSummary(
        modelPackageName,
        modelPackageGroupName.map(value => value),
        modelPackageVersion.map(value => value),
        modelPackageArn,
        modelPackageDescription.map(value => value),
        creationTime,
        modelPackageStatus,
        modelApprovalStatus.map(value => value)
      )
    def modelPackageName: EntityName
    def modelPackageGroupName: Optional[EntityName]
    def modelPackageVersion: Optional[ModelPackageVersion]
    def modelPackageArn: ModelPackageArn
    def modelPackageDescription: Optional[EntityDescription]
    def creationTime: CreationTime
    def modelPackageStatus: zio.aws.sagemaker.model.ModelPackageStatus
    def modelApprovalStatus
        : Optional[zio.aws.sagemaker.model.ModelApprovalStatus]
    def getModelPackageName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelPackageName)
    def getModelPackageGroupName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("modelPackageGroupName", modelPackageGroupName)
    def getModelPackageVersion: ZIO[Any, AwsError, ModelPackageVersion] =
      AwsError.unwrapOptionField("modelPackageVersion", modelPackageVersion)
    def getModelPackageArn: ZIO[Any, Nothing, ModelPackageArn] =
      ZIO.succeed(modelPackageArn)
    def getModelPackageDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField(
        "modelPackageDescription",
        modelPackageDescription
      )
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getModelPackageStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ModelPackageStatus] =
      ZIO.succeed(modelPackageStatus)
    def getModelApprovalStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelApprovalStatus] =
      AwsError.unwrapOptionField("modelApprovalStatus", modelApprovalStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelPackageSummary
  ) extends zio.aws.sagemaker.model.ModelPackageSummary.ReadOnly {
    override val modelPackageName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.modelPackageName())
    override val modelPackageGroupName: Optional[EntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelPackageGroupName())
        .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val modelPackageVersion: Optional[ModelPackageVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelPackageVersion())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ModelPackageVersion(value)
        )
    override val modelPackageArn: ModelPackageArn =
      zio.aws.sagemaker.model.primitives.ModelPackageArn(impl.modelPackageArn())
    override val modelPackageDescription: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelPackageDescription())
        .map(value =>
          zio.aws.sagemaker.model.primitives.EntityDescription(value)
        )
    override val creationTime: CreationTime =
      zio.aws.sagemaker.model.primitives.CreationTime(impl.creationTime())
    override val modelPackageStatus
        : zio.aws.sagemaker.model.ModelPackageStatus =
      zio.aws.sagemaker.model.ModelPackageStatus.wrap(impl.modelPackageStatus())
    override val modelApprovalStatus
        : Optional[zio.aws.sagemaker.model.ModelApprovalStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelApprovalStatus())
        .map(value => zio.aws.sagemaker.model.ModelApprovalStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelPackageSummary
  ): zio.aws.sagemaker.model.ModelPackageSummary.ReadOnly = new Wrapper(impl)
}
