package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  S3Uri,
  ProcessingEnvironmentValue,
  ProcessingEnvironmentKey,
  ContainerArgument,
  ContainerEntrypointString,
  ImageUri
}
import scala.jdk.CollectionConverters.*
final case class ModelQualityAppSpecification(
    imageUri: ImageUri,
    containerEntrypoint: Optional[Iterable[ContainerEntrypointString]] =
      Optional.Absent,
    containerArguments: Optional[Iterable[ContainerArgument]] = Optional.Absent,
    recordPreprocessorSourceUri: Optional[S3Uri] = Optional.Absent,
    postAnalyticsProcessorSourceUri: Optional[S3Uri] = Optional.Absent,
    problemType: Optional[zio.aws.sagemaker.model.MonitoringProblemType] =
      Optional.Absent,
    environment: Optional[
      Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelQualityAppSpecification = {
    import ModelQualityAppSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelQualityAppSpecification
      .builder()
      .imageUri(ImageUri.unwrap(imageUri): java.lang.String)
      .optionallyWith(
        containerEntrypoint.map(value =>
          value.map { item =>
            ContainerEntrypointString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.containerEntrypoint)
      .optionallyWith(
        containerArguments.map(value =>
          value.map { item =>
            ContainerArgument.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.containerArguments)
      .optionallyWith(
        recordPreprocessorSourceUri.map(value =>
          S3Uri.unwrap(value): java.lang.String
        )
      )(_.recordPreprocessorSourceUri)
      .optionallyWith(
        postAnalyticsProcessorSourceUri.map(value =>
          S3Uri.unwrap(value): java.lang.String
        )
      )(_.postAnalyticsProcessorSourceUri)
      .optionallyWith(problemType.map(value => value.unwrap))(_.problemType)
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (ProcessingEnvironmentKey
                .unwrap(key): java.lang.String) -> (ProcessingEnvironmentValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ModelQualityAppSpecification.ReadOnly =
    zio.aws.sagemaker.model.ModelQualityAppSpecification.wrap(buildAwsValue())
}
object ModelQualityAppSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelQualityAppSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelQualityAppSpecification =
      zio.aws.sagemaker.model.ModelQualityAppSpecification(
        imageUri,
        containerEntrypoint.map(value => value),
        containerArguments.map(value => value),
        recordPreprocessorSourceUri.map(value => value),
        postAnalyticsProcessorSourceUri.map(value => value),
        problemType.map(value => value),
        environment.map(value => value)
      )
    def imageUri: ImageUri
    def containerEntrypoint: Optional[List[ContainerEntrypointString]]
    def containerArguments: Optional[List[ContainerArgument]]
    def recordPreprocessorSourceUri: Optional[S3Uri]
    def postAnalyticsProcessorSourceUri: Optional[S3Uri]
    def problemType: Optional[zio.aws.sagemaker.model.MonitoringProblemType]
    def environment
        : Optional[Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]]
    def getImageUri: ZIO[Any, Nothing, ImageUri] = ZIO.succeed(imageUri)
    def getContainerEntrypoint
        : ZIO[Any, AwsError, List[ContainerEntrypointString]] =
      AwsError.unwrapOptionField("containerEntrypoint", containerEntrypoint)
    def getContainerArguments: ZIO[Any, AwsError, List[ContainerArgument]] =
      AwsError.unwrapOptionField("containerArguments", containerArguments)
    def getRecordPreprocessorSourceUri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField(
        "recordPreprocessorSourceUri",
        recordPreprocessorSourceUri
      )
    def getPostAnalyticsProcessorSourceUri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField(
        "postAnalyticsProcessorSourceUri",
        postAnalyticsProcessorSourceUri
      )
    def getProblemType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MonitoringProblemType] =
      AwsError.unwrapOptionField("problemType", problemType)
    def getEnvironment: ZIO[Any, AwsError, Map[
      ProcessingEnvironmentKey,
      ProcessingEnvironmentValue
    ]] = AwsError.unwrapOptionField("environment", environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelQualityAppSpecification
  ) extends zio.aws.sagemaker.model.ModelQualityAppSpecification.ReadOnly {
    override val imageUri: ImageUri =
      zio.aws.sagemaker.model.primitives.ImageUri(impl.imageUri())
    override val containerEntrypoint
        : Optional[List[ContainerEntrypointString]] = zio.aws.core.internal
      .optionalFromNullable(impl.containerEntrypoint())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.ContainerEntrypointString(item)
        }.toList
      )
    override val containerArguments: Optional[List[ContainerArgument]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerArguments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.ContainerArgument(item)
          }.toList
        )
    override val recordPreprocessorSourceUri: Optional[S3Uri] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordPreprocessorSourceUri())
        .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val postAnalyticsProcessorSourceUri: Optional[S3Uri] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postAnalyticsProcessorSourceUri())
        .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val problemType
        : Optional[zio.aws.sagemaker.model.MonitoringProblemType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.problemType())
        .map(value => zio.aws.sagemaker.model.MonitoringProblemType.wrap(value))
    override val environment
        : Optional[Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.ProcessingEnvironmentKey(
                key
              ) -> zio.aws.sagemaker.model.primitives
                .ProcessingEnvironmentValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelQualityAppSpecification
  ): zio.aws.sagemaker.model.ModelQualityAppSpecification.ReadOnly =
    new Wrapper(impl)
}
