package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{Timestamp, ModelArn, ModelName}
import scala.jdk.CollectionConverters.*
final case class ModelSummary(
    modelName: ModelName,
    modelArn: ModelArn,
    creationTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelSummary = {
    import ModelSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelSummary
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .modelArn(ModelArn.unwrap(modelArn): java.lang.String)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelSummary.ReadOnly =
    zio.aws.sagemaker.model.ModelSummary.wrap(buildAwsValue())
}
object ModelSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelSummary =
      zio.aws.sagemaker.model.ModelSummary(modelName, modelArn, creationTime)
    def modelName: ModelName
    def modelArn: ModelArn
    def creationTime: Timestamp
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
    def getModelArn: ZIO[Any, Nothing, ModelArn] = ZIO.succeed(modelArn)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelSummary
  ) extends zio.aws.sagemaker.model.ModelSummary.ReadOnly {
    override val modelName: ModelName =
      zio.aws.sagemaker.model.primitives.ModelName(impl.modelName())
    override val modelArn: ModelArn =
      zio.aws.sagemaker.model.primitives.ModelArn(impl.modelArn())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelSummary
  ): zio.aws.sagemaker.model.ModelSummary.ReadOnly = new Wrapper(impl)
}
