package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MonitoringResources(
    clusterConfig: zio.aws.sagemaker.model.MonitoringClusterConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringResources = {
    import MonitoringResources.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringResources
      .builder()
      .clusterConfig(clusterConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringResources.ReadOnly =
    zio.aws.sagemaker.model.MonitoringResources.wrap(buildAwsValue())
}
object MonitoringResources {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringResources
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringResources =
      zio.aws.sagemaker.model.MonitoringResources(clusterConfig.asEditable)
    def clusterConfig: zio.aws.sagemaker.model.MonitoringClusterConfig.ReadOnly
    def getClusterConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringClusterConfig.ReadOnly
    ] = ZIO.succeed(clusterConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringResources
  ) extends zio.aws.sagemaker.model.MonitoringResources.ReadOnly {
    override val clusterConfig
        : zio.aws.sagemaker.model.MonitoringClusterConfig.ReadOnly =
      zio.aws.sagemaker.model.MonitoringClusterConfig.wrap(impl.clusterConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringResources
  ): zio.aws.sagemaker.model.MonitoringResources.ReadOnly = new Wrapper(impl)
}
