package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait MonitoringType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.MonitoringType
}
object MonitoringType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.MonitoringType
  ): zio.aws.sagemaker.model.MonitoringType = value match {
    case software.amazon.awssdk.services.sagemaker.model.MonitoringType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.MonitoringType.DATA_QUALITY =>
      val r = DataQuality
      r
    case software.amazon.awssdk.services.sagemaker.model.MonitoringType.MODEL_QUALITY =>
      val r = ModelQuality
      r
    case software.amazon.awssdk.services.sagemaker.model.MonitoringType.MODEL_BIAS =>
      val r = ModelBias
      r
    case software.amazon.awssdk.services.sagemaker.model.MonitoringType.MODEL_EXPLAINABILITY =>
      val r = ModelExplainability
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.MonitoringType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.MonitoringType =
      software.amazon.awssdk.services.sagemaker.model.MonitoringType.UNKNOWN_TO_SDK_VERSION
  }
  case object DataQuality extends zio.aws.sagemaker.model.MonitoringType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.MonitoringType =
      software.amazon.awssdk.services.sagemaker.model.MonitoringType.DATA_QUALITY
  }
  case object ModelQuality extends zio.aws.sagemaker.model.MonitoringType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.MonitoringType =
      software.amazon.awssdk.services.sagemaker.model.MonitoringType.MODEL_QUALITY
  }
  case object ModelBias extends zio.aws.sagemaker.model.MonitoringType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.MonitoringType =
      software.amazon.awssdk.services.sagemaker.model.MonitoringType.MODEL_BIAS
  }
  case object ModelExplainability
      extends zio.aws.sagemaker.model.MonitoringType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.MonitoringType =
      software.amazon.awssdk.services.sagemaker.model.MonitoringType.MODEL_EXPLAINABILITY
  }
}
