package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{
  NeoVpcSubnetId,
  NeoVpcSecurityGroupId
}
import scala.jdk.CollectionConverters.*
final case class NeoVpcConfig(
    securityGroupIds: Iterable[NeoVpcSecurityGroupId],
    subnets: Iterable[NeoVpcSubnetId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.NeoVpcConfig = {
    import NeoVpcConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.NeoVpcConfig
      .builder()
      .securityGroupIds(securityGroupIds.map { item =>
        NeoVpcSecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .subnets(subnets.map { item =>
        NeoVpcSubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.NeoVpcConfig.ReadOnly =
    zio.aws.sagemaker.model.NeoVpcConfig.wrap(buildAwsValue())
}
object NeoVpcConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.NeoVpcConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.NeoVpcConfig =
      zio.aws.sagemaker.model.NeoVpcConfig(securityGroupIds, subnets)
    def securityGroupIds: List[NeoVpcSecurityGroupId]
    def subnets: List[NeoVpcSubnetId]
    def getSecurityGroupIds: ZIO[Any, Nothing, List[NeoVpcSecurityGroupId]] =
      ZIO.succeed(securityGroupIds)
    def getSubnets: ZIO[Any, Nothing, List[NeoVpcSubnetId]] =
      ZIO.succeed(subnets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.NeoVpcConfig
  ) extends zio.aws.sagemaker.model.NeoVpcConfig.ReadOnly {
    override val securityGroupIds: List[NeoVpcSecurityGroupId] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.NeoVpcSecurityGroupId(item)
      }
      .toList
    override val subnets: List[NeoVpcSubnetId] = impl
      .subnets()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.NeoVpcSubnetId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.NeoVpcConfig
  ): zio.aws.sagemaker.model.NeoVpcConfig.ReadOnly = new Wrapper(impl)
}
