package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NetworkConfig(
    enableInterContainerTrafficEncryption: Optional[Boolean] = Optional.Absent,
    enableNetworkIsolation: Optional[Boolean] = Optional.Absent,
    vpcConfig: Optional[zio.aws.sagemaker.model.VpcConfig] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.NetworkConfig = {
    import NetworkConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.NetworkConfig
      .builder()
      .optionallyWith(
        enableInterContainerTrafficEncryption.map(value =>
          value: java.lang.Boolean
        )
      )(_.enableInterContainerTrafficEncryption)
      .optionallyWith(
        enableNetworkIsolation.map(value => value: java.lang.Boolean)
      )(_.enableNetworkIsolation)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.NetworkConfig.ReadOnly =
    zio.aws.sagemaker.model.NetworkConfig.wrap(buildAwsValue())
}
object NetworkConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.NetworkConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.NetworkConfig =
      zio.aws.sagemaker.model.NetworkConfig(
        enableInterContainerTrafficEncryption.map(value => value),
        enableNetworkIsolation.map(value => value),
        vpcConfig.map(value => value.asEditable)
      )
    def enableInterContainerTrafficEncryption: Optional[Boolean]
    def enableNetworkIsolation: Optional[Boolean]
    def vpcConfig: Optional[zio.aws.sagemaker.model.VpcConfig.ReadOnly]
    def getEnableInterContainerTrafficEncryption: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableInterContainerTrafficEncryption",
        enableInterContainerTrafficEncryption
      )
    def getEnableNetworkIsolation: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableNetworkIsolation", enableNetworkIsolation)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.NetworkConfig
  ) extends zio.aws.sagemaker.model.NetworkConfig.ReadOnly {
    override val enableInterContainerTrafficEncryption: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableInterContainerTrafficEncryption())
        .map(value => value: Boolean)
    override val enableNetworkIsolation: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableNetworkIsolation())
        .map(value => value: Boolean)
    override val vpcConfig
        : Optional[zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.sagemaker.model.VpcConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.NetworkConfig
  ): zio.aws.sagemaker.model.NetworkConfig.ReadOnly = new Wrapper(impl)
}
