package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NotebookInstanceLifecycleConfigContent
import scala.jdk.CollectionConverters.*
final case class NotebookInstanceLifecycleHook(
    content: Optional[NotebookInstanceLifecycleConfigContent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleHook = {
    import NotebookInstanceLifecycleHook.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleHook
      .builder()
      .optionallyWith(
        content.map(value =>
          NotebookInstanceLifecycleConfigContent.unwrap(value): java.lang.String
        )
      )(_.content)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly =
    zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.wrap(buildAwsValue())
}
object NotebookInstanceLifecycleHook {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleHook
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.NotebookInstanceLifecycleHook =
      zio.aws.sagemaker.model
        .NotebookInstanceLifecycleHook(content.map(value => value))
    def content: Optional[NotebookInstanceLifecycleConfigContent]
    def getContent: ZIO[Any, AwsError, NotebookInstanceLifecycleConfigContent] =
      AwsError.unwrapOptionField("content", content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleHook
  ) extends zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly {
    override val content: Optional[NotebookInstanceLifecycleConfigContent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.content())
        .map(value =>
          zio.aws.sagemaker.model.primitives
            .NotebookInstanceLifecycleConfigContent(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.NotebookInstanceLifecycleHook
  ): zio.aws.sagemaker.model.NotebookInstanceLifecycleHook.ReadOnly =
    new Wrapper(impl)
}
