package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait NotebookInstanceSortKey {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortKey
}
object NotebookInstanceSortKey {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortKey
  ): zio.aws.sagemaker.model.NotebookInstanceSortKey = value match {
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortKey.NAME =>
      val r = Name
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortKey.CREATION_TIME =>
      val r = CreationTime
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortKey.STATUS =>
      val r = Status
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.NotebookInstanceSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortKey =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortKey.UNKNOWN_TO_SDK_VERSION
  }
  case object Name extends zio.aws.sagemaker.model.NotebookInstanceSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortKey =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortKey.NAME
  }
  case object CreationTime
      extends zio.aws.sagemaker.model.NotebookInstanceSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortKey =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortKey.CREATION_TIME
  }
  case object Status extends zio.aws.sagemaker.model.NotebookInstanceSortKey {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortKey =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSortKey.STATUS
  }
}
